/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.dse.driver.internal.core.data.geometry.SerializationUtils;
import com.esri.core.geometry.ogc.OGCPoint;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Test;

public class DefaultPointTest {
    private DefaultPoint point = new DefaultPoint(1.1, 2.2);
    private final String wkt = "POINT (1.1 2.2)";
    private final String json = "{\"type\":\"Point\",\"coordinates\":[1.1,2.2]}";

    @Test
    public void should_parse_valid_well_known_text() {
        Assertions.assertThat((Object)Point.fromWellKnownText((String)"POINT (1.1 2.2)")).isEqualTo((Object)this.point);
    }

    @Test
    public void should_fail_to_parse_invalid_well_known_text() {
        this.assertInvalidWkt("superpoint(1.1 2.2 3.3)");
    }

    @Test
    public void should_convert_to_well_known_text() {
        Assertions.assertThat((String)this.point.toString()).isEqualTo("POINT (1.1 2.2)");
    }

    @Test
    public void should_convert_to_well_knowm_binary() {
        ByteBuffer actual = this.point.asWellKnownBinary();
        ByteBuffer expected = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        expected.position(0);
        expected.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        expected.putInt(1);
        expected.putDouble(1.1);
        expected.putDouble(2.2);
        expected.flip();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
    }

    @Test
    public void should_load_from_well_known_binary() {
        ByteBuffer bb = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        bb.position(0);
        bb.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        bb.putInt(1);
        bb.putDouble(1.1);
        bb.putDouble(2.2);
        bb.flip();
        Assertions.assertThat((Object)Point.fromWellKnownBinary((ByteBuffer)bb)).isEqualTo((Object)this.point);
    }

    @Test
    public void should_parse_valid_geo_json() {
        Assertions.assertThat((Object)Point.fromGeoJson((String)"{\"type\":\"Point\",\"coordinates\":[1.1,2.2]}")).isEqualTo((Object)this.point);
    }

    @Test
    public void should_convert_to_geo_json() {
        Assertions.assertThat((String)this.point.asGeoJson()).isEqualTo("{\"type\":\"Point\",\"coordinates\":[1.1,2.2]}");
    }

    @Test
    public void should_convert_to_ogc_point() {
        Assertions.assertThat((Object)this.point.getOgcGeometry()).isInstanceOf(OGCPoint.class);
    }

    @Test
    public void should_produce_same_hashCode_for_equal_objects() {
        DefaultPoint point1 = new DefaultPoint(10.0, 20.0);
        Point point2 = Point.fromWellKnownText((String)"POINT (10 20)");
        Assertions.assertThat((Object)point1).isEqualTo((Object)point2);
        Assertions.assertThat((int)point1.hashCode()).isEqualTo(point2.hashCode());
    }

    @Test
    public void should_encode_and_decode() throws Exception {
        Assertions.assertThat((Object)SerializationUtils.serializeAndDeserialize((Geometry)this.point)).isEqualTo((Object)this.point);
    }

    @Test
    public void should_contain_self() {
        Assertions.assertThat((boolean)this.point.contains((Geometry)this.point)).isTrue();
    }

    @Test
    public void should_not_contain_any_other_shape_than_self() {
        DefaultPoint point2 = new DefaultPoint(1.0, 2.0);
        DefaultPoint point3 = new DefaultPoint(1.0, 3.0);
        Assertions.assertThat((boolean)this.point.contains((Geometry)point2)).isFalse();
        Assertions.assertThat((boolean)this.point.contains((Geometry)new DefaultLineString((Point)this.point, (Point)point2, new Point[0]))).isFalse();
        Assertions.assertThat((boolean)this.point.contains((Geometry)new DefaultPolygon((Point)this.point, (Point)point2, (Point)point3, new Point[0]))).isFalse();
    }

    @Test
    public void should_accept_empty_shape() throws Exception {
        DefaultPoint point = (DefaultPoint)Point.fromWellKnownText((String)"POINT EMPTY");
        Assertions.assertThat((boolean)point.getOgcGeometry().isEmpty()).isTrue();
    }

    private void assertInvalidWkt(String s) {
        try {
            Point.fromWellKnownText((String)s);
            Fail.fail((String)"Should have thrown InvalidTypeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

