/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.datastax.dse.driver.internal.core.data.geometry.SerializationUtils;
import com.esri.core.geometry.ogc.OGCLineString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Test;

public class DefaultLineStringTest {
    private final LineString lineString = LineString.fromPoints((Point)Point.fromCoordinates((double)30.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)30.0), (Point[])new Point[]{Point.fromCoordinates((double)40.0, (double)40.0)});
    private final String wkt = "LINESTRING (30 10, 10 30, 40 40)";
    private final String json = "{\"type\":\"LineString\",\"coordinates\":[[30.0,10.0],[10.0,30.0],[40.0,40.0]]}";

    @Test
    public void should_parse_valid_well_known_text() {
        Assertions.assertThat((Object)LineString.fromWellKnownText((String)"LINESTRING (30 10, 10 30, 40 40)")).isEqualTo((Object)this.lineString);
    }

    @Test
    public void should_fail_to_parse_invalid_well_known_text() {
        this.assertInvalidWkt("linestring()");
        this.assertInvalidWkt("linestring(30 10 20, 10 30 20)");
        this.assertInvalidWkt("linestring(0 0, 1 1, 0 1, 1 0)");
        this.assertInvalidWkt("superlinestring(30 10, 10 30, 40 40)");
    }

    @Test
    public void should_convert_to_well_known_text() {
        Assertions.assertThat((String)this.lineString.toString()).isEqualTo("LINESTRING (30 10, 10 30, 40 40)");
    }

    @Test
    public void should_convert_to_well_known_binary() {
        ByteBuffer actual = this.lineString.asWellKnownBinary();
        ByteBuffer expected = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        expected.position(0);
        expected.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        expected.putInt(2);
        expected.putInt(3);
        expected.putDouble(30.0);
        expected.putDouble(10.0);
        expected.putDouble(10.0);
        expected.putDouble(30.0);
        expected.putDouble(40.0);
        expected.putDouble(40.0);
        expected.flip();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
    }

    @Test
    public void should_load_from_well_known_binary() {
        ByteBuffer bb = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        bb.position(0);
        bb.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        bb.putInt(2);
        bb.putInt(3);
        bb.putDouble(30.0);
        bb.putDouble(10.0);
        bb.putDouble(10.0);
        bb.putDouble(30.0);
        bb.putDouble(40.0);
        bb.putDouble(40.0);
        bb.flip();
        Assertions.assertThat((Object)LineString.fromWellKnownBinary((ByteBuffer)bb)).isEqualTo((Object)this.lineString);
    }

    @Test
    public void should_parse_valid_geo_json() {
        Assertions.assertThat((Object)LineString.fromGeoJson((String)"{\"type\":\"LineString\",\"coordinates\":[[30.0,10.0],[10.0,30.0],[40.0,40.0]]}")).isEqualTo((Object)this.lineString);
    }

    @Test
    public void should_convert_to_geo_json() {
        Assertions.assertThat((String)this.lineString.asGeoJson()).isEqualTo("{\"type\":\"LineString\",\"coordinates\":[[30.0,10.0],[10.0,30.0],[40.0,40.0]]}");
    }

    @Test
    public void should_convert_to_ogc_line_string() {
        Assertions.assertThat((Object)((DefaultLineString)this.lineString).getOgcGeometry()).isInstanceOf(OGCLineString.class);
    }

    @Test
    public void should_produce_same_hashCode_for_equal_objects() {
        LineString line1 = LineString.fromPoints((Point)Point.fromCoordinates((double)30.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)30.0), (Point[])new Point[]{Point.fromCoordinates((double)40.0, (double)40.0)});
        LineString line2 = LineString.fromWellKnownText((String)"LINESTRING (30 10, 10 30, 40 40)");
        Assertions.assertThat((Object)line1).isEqualTo((Object)line2);
        Assertions.assertThat((int)line1.hashCode()).isEqualTo(line2.hashCode());
    }

    @Test
    public void should_expose_points() {
        Assertions.assertThat((List)this.lineString.getPoints()).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)30.0, (double)10.0), Point.fromCoordinates((double)10.0, (double)30.0), Point.fromCoordinates((double)40.0, (double)40.0)});
        Assertions.assertThat((List)LineString.fromWellKnownText((String)"LINESTRING (30 10, 10 30, 40 40)").getPoints()).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)30.0, (double)10.0), Point.fromCoordinates((double)10.0, (double)30.0), Point.fromCoordinates((double)40.0, (double)40.0)});
    }

    @Test
    public void should_encode_and_decode() throws Exception {
        Assertions.assertThat((Object)SerializationUtils.serializeAndDeserialize((Geometry)this.lineString)).isEqualTo((Object)this.lineString);
    }

    @Test
    public void should_contain_self() {
        Assertions.assertThat((boolean)this.lineString.contains((Geometry)this.lineString)).isTrue();
    }

    @Test
    public void should_contain_all_intersected_points_except_start_and_end() {
        LineString s = LineString.fromPoints((Point)Point.fromCoordinates((double)0.0, (double)0.0), (Point)Point.fromCoordinates((double)0.0, (double)30.0), (Point[])new Point[]{Point.fromCoordinates((double)30.0, (double)30.0)});
        Assertions.assertThat((boolean)s.contains((Geometry)Point.fromCoordinates((double)0.0, (double)0.0))).isFalse();
        Assertions.assertThat((boolean)s.contains((Geometry)Point.fromCoordinates((double)0.0, (double)15.0))).isTrue();
        Assertions.assertThat((boolean)s.contains((Geometry)Point.fromCoordinates((double)0.0, (double)30.0))).isTrue();
        Assertions.assertThat((boolean)s.contains((Geometry)Point.fromCoordinates((double)15.0, (double)30.0))).isTrue();
        Assertions.assertThat((boolean)s.contains((Geometry)Point.fromCoordinates((double)30.0, (double)30.0))).isFalse();
    }

    @Test
    public void should_contain_substring() {
        Assertions.assertThat((boolean)this.lineString.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)30.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)30.0), (Point[])new Point[0]))).isTrue();
    }

    @Test
    public void should_not_contain_unrelated_string() {
        Assertions.assertThat((boolean)this.lineString.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)10.0, (double)10.0), (Point)Point.fromCoordinates((double)30.0, (double)30.0), (Point[])new Point[0]))).isFalse();
    }

    @Test
    public void should_not_contain_polygon() {
        LineString s = LineString.fromPoints((Point)Point.fromCoordinates((double)0.0, (double)0.0), (Point)Point.fromCoordinates((double)0.0, (double)30.0), (Point[])new Point[]{Point.fromCoordinates((double)30.0, (double)30.0), Point.fromCoordinates((double)30.0, (double)0.0)});
        LineString p = LineString.fromPoints((Point)Point.fromCoordinates((double)10.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)20.0), (Point[])new Point[]{Point.fromCoordinates((double)20.0, (double)20.0), Point.fromCoordinates((double)20.0, (double)10.0)});
        Assertions.assertThat((boolean)s.contains((Geometry)p)).isFalse();
    }

    @Test
    public void should_accept_empty_shape() throws Exception {
        DefaultLineString s = (DefaultLineString)LineString.fromWellKnownText((String)"LINESTRING EMPTY");
        Assertions.assertThat((boolean)s.getOgcGeometry().isEmpty()).isTrue();
    }

    private void assertInvalidWkt(String s) {
        try {
            LineString.fromWellKnownText((String)s);
            Fail.fail((String)"Should have thrown InvalidTypeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

