/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandler;
import com.datastax.dse.driver.internal.core.cql.continuous.DefaultContinuousAsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultContinuousAsyncResultSetTest {
    @Mock
    private ColumnDefinitions columnDefinitions;
    @Mock
    private ExecutionInfo executionInfo;
    @Mock
    private ContinuousCqlRequestHandler handler;
    @Mock
    private CountingIterator<Row> rows;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void should_fail_to_fetch_next_page_if_last() {
        BDDMockito.given((Object)this.executionInfo.getPagingState()).willReturn(null);
        DefaultContinuousAsyncResultSet resultSet = new DefaultContinuousAsyncResultSet(this.rows, this.columnDefinitions, 1, false, this.executionInfo, this.handler);
        boolean hasMorePages = resultSet.hasMorePages();
        ThrowableAssert.ThrowingCallable nextPage = () -> ((DefaultContinuousAsyncResultSet)resultSet).fetchNextPage();
        com.datastax.oss.driver.Assertions.assertThat((boolean)hasMorePages).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)nextPage).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Can't call fetchNextPage() on the last page");
    }

    @Test
    public void should_invoke_handler_to_fetch_next_page() {
        CompletableFuture mockResultFuture = new CompletableFuture();
        BDDMockito.given((Object)this.handler.fetchNextPage()).willReturn(mockResultFuture);
        DefaultContinuousAsyncResultSet resultSet = new DefaultContinuousAsyncResultSet(this.rows, this.columnDefinitions, 1, true, this.executionInfo, this.handler);
        boolean hasMorePages = resultSet.hasMorePages();
        CompletionStage nextPageFuture = resultSet.fetchNextPage();
        com.datastax.oss.driver.Assertions.assertThat((boolean)hasMorePages).isTrue();
        ((ContinuousCqlRequestHandler)Mockito.verify((Object)this.handler)).fetchNextPage();
        com.datastax.oss.driver.Assertions.assertThat((CompletionStage)nextPageFuture).isEqualTo(mockResultFuture);
    }

    @Test
    public void should_invoke_handler_to_cancel() {
        DefaultContinuousAsyncResultSet resultSet = new DefaultContinuousAsyncResultSet(this.rows, this.columnDefinitions, 1, true, this.executionInfo, this.handler);
        resultSet.cancel();
        ((ContinuousCqlRequestHandler)Mockito.verify((Object)this.handler)).cancel();
    }

    @Test
    public void should_report_remaining_rows() {
        BDDMockito.given((Object)this.rows.remaining()).willReturn((Object)42);
        DefaultContinuousAsyncResultSet resultSet = new DefaultContinuousAsyncResultSet(this.rows, this.columnDefinitions, 1, true, this.executionInfo, this.handler);
        int remaining = resultSet.remaining();
        Iterable currentPage = resultSet.currentPage();
        com.datastax.oss.driver.Assertions.assertThat((int)remaining).isEqualTo(42);
        com.datastax.oss.driver.Assertions.assertThat(currentPage.iterator()).isSameAs(this.rows);
    }
}

