/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.DseTestFixtures;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandler;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandlerTestBase;
import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.DefaultWriteType;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.ServerError;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.error.ReadTimeout;
import com.datastax.oss.protocol.internal.response.error.Unavailable;
import com.datastax.oss.protocol.internal.response.error.WriteTimeout;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ContinuousCqlRequestHandlerRetryTest
extends ContinuousCqlRequestHandlerTestBase {
    @Test
    @UseDataProvider(value="allIdempotenceConfigs")
    public void should_always_try_next_node_if_bootstrapping(boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence).withResponse((Node)this.node1, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)new Error(4098, "mock message"))).withResponse((Node)this.node2, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow())).build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-1);
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node2);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(1);
                Assertions.assertThat((Object)((Node)((Map.Entry)executionInfo.getErrors().get(0)).getKey())).isEqualTo((Object)this.node1);
                Assertions.assertThat((Throwable)((Throwable)((Map.Entry)executionInfo.getErrors().get(0)).getValue())).isInstanceOf(BootstrappingException.class);
                Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
                Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getContext().getRetryPolicy(ArgumentMatchers.anyString())});
            });
        }
    }

    @Test
    @UseDataProvider(value="allIdempotenceConfigs")
    public void should_always_rethrow_query_validation_error(boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        try (RequestHandlerTestHarness harness = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence).withResponse((Node)this.node1, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)new Error(8704, "mock message"))).build();){
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(InvalidQueryException.class)).hasMessage("mock message");
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getContext().getRetryPolicy(ArgumentMatchers.anyString())});
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.OTHER_ERRORS)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_try_next_node_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder harnessBuilder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        harnessBuilder.withResponse((Node)this.node2, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyVerdict(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryVerdict.RETRY_NEXT);
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-1);
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node2);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(1);
                Assertions.assertThat((Object)((Node)((Map.Entry)executionInfo.getErrors().get(0)).getKey())).isEqualTo((Object)this.node1);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.errorMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.RETRIES)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.retryMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_try_same_node_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder harnessBuilder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        harnessBuilder.withResponse((Node)this.node1, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyVerdict(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryVerdict.RETRY_SAME);
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-1);
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(1);
                Assertions.assertThat((Object)((Node)((Map.Entry)executionInfo.getErrors().get(0)).getKey())).isEqualTo((Object)this.node1);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.errorMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.RETRIES)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.retryMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)2))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_ignore_error_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder harnessBuilder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyVerdict(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryVerdict.IGNORE);
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-1);
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isFalse();
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                Assertions.assertThat((List)executionInfo.getErrors()).hasSize(0);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.errorMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.IGNORES)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.ignoreMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndIdempotent")
    public void should_rethrow_error_if_idempotent_and_retry_policy_decides_so(FailureScenario failureScenario, boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        RequestHandlerTestHarness.Builder harnessBuilder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            failureScenario.mockRetryPolicyVerdict(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryVerdict.RETHROW);
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(failureScenario.expectedExceptionClass);
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.errorMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @Test
    @UseDataProvider(value="failureAndNotIdempotent")
    public void should_rethrow_error_if_not_idempotent_and_error_unsafe_or_policy_rethrows(FailureScenario failureScenario, boolean defaultIdempotence, Statement<?> statement, DseProtocolVersion version) {
        boolean shouldCallRetryPolicy = failureScenario.expectedExceptionClass.equals(UnavailableException.class) || failureScenario.expectedExceptionClass.equals(ReadTimeoutException.class);
        RequestHandlerTestHarness.Builder harnessBuilder = this.continuousHarnessBuilder().withProtocolVersion((ProtocolVersion)version).withDefaultIdempotence(defaultIdempotence);
        failureScenario.mockRequestError(harnessBuilder, (Node)this.node1);
        harnessBuilder.withResponse((Node)this.node2, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)DseTestFixtures.singleDseRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            if (shouldCallRetryPolicy) {
                failureScenario.mockRetryPolicyVerdict(harness.getContext().getRetryPolicy(ArgumentMatchers.anyString()), RetryVerdict.RETHROW);
            }
            ContinuousCqlRequestHandler handler = new ContinuousCqlRequestHandler(statement, harness.getSession(), harness.getContext(), "test");
            CompletionStage resultSetFuture = handler.handle();
            Assertions.assertThat((int)handler.getState()).isEqualTo(-2);
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(failureScenario.expectedExceptionClass);
                if (!shouldCallRetryPolicy) {
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getContext().getRetryPolicy(ArgumentMatchers.anyString())});
                }
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)((NodeMetric)ArgumentMatchers.eq((Object)failureScenario.errorMetric)), ArgumentMatchers.anyString());
                ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.atMost((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DefaultNodeMetric.CQL_MESSAGES)), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS)))));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            });
        }
    }

    @DataProvider
    public static Object[][] failure() {
        return TestDataProviders.fromList(new FailureScenario(ReadTimeoutException.class, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)new ReadTimeout("mock message", 10, 1, 2, true)));
            }

            @Override
            public void mockRetryPolicyVerdict(RetryPolicy policy, RetryVerdict verdict) {
                Mockito.when((Object)policy.onReadTimeoutVerdict((Request)ArgumentMatchers.any(SimpleStatement.class), (ConsistencyLevel)ArgumentMatchers.eq((Object)DefaultConsistencyLevel.LOCAL_ONE), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((int)0))).thenReturn((Object)verdict);
            }
        }, new FailureScenario(WriteTimeoutException.class, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)new WriteTimeout("mock message", 10, 1, 2, "SIMPLE")));
            }

            @Override
            public void mockRetryPolicyVerdict(RetryPolicy policy, RetryVerdict verdict) {
                Mockito.when((Object)policy.onWriteTimeoutVerdict((Request)ArgumentMatchers.any(SimpleStatement.class), (ConsistencyLevel)ArgumentMatchers.eq((Object)DefaultConsistencyLevel.LOCAL_ONE), (WriteType)ArgumentMatchers.eq((Object)DefaultWriteType.SIMPLE), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)0))).thenReturn((Object)verdict);
            }
        }, new FailureScenario(UnavailableException.class, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)new Unavailable("mock message", 10, 2, 1)));
            }

            @Override
            public void mockRetryPolicyVerdict(RetryPolicy policy, RetryVerdict verdict) {
                Mockito.when((Object)policy.onUnavailableVerdict((Request)ArgumentMatchers.any(SimpleStatement.class), (ConsistencyLevel)ArgumentMatchers.eq((Object)DefaultConsistencyLevel.LOCAL_ONE), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)0))).thenReturn((Object)verdict);
            }
        }, new FailureScenario(ServerError.class, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponse(node, ContinuousCqlRequestHandlerRetryTest.defaultFrameOf((Message)new Error(0, "mock server error")));
            }

            @Override
            public void mockRetryPolicyVerdict(RetryPolicy policy, RetryVerdict verdict) {
                Mockito.when((Object)policy.onErrorResponseVerdict((Request)ArgumentMatchers.any(SimpleStatement.class), (CoordinatorException)ArgumentMatchers.any(ServerError.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)verdict);
            }
        }, new FailureScenario(HeartbeatException.class, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED){

            @Override
            public void mockRequestError(RequestHandlerTestHarness.Builder builder, Node node) {
                builder.withResponseFailure(node, (Throwable)Mockito.mock(HeartbeatException.class));
            }

            @Override
            public void mockRetryPolicyVerdict(RetryPolicy policy, RetryVerdict verdict) {
                Mockito.when((Object)policy.onRequestAbortedVerdict((Request)ArgumentMatchers.any(SimpleStatement.class), (Throwable)ArgumentMatchers.any(HeartbeatException.class), ArgumentMatchers.eq((int)0))).thenReturn((Object)verdict);
            }
        });
    }

    @DataProvider
    public static Object[][] failureAndIdempotent() {
        return TestDataProviders.combine(ContinuousCqlRequestHandlerRetryTest.failure(), ContinuousCqlRequestHandlerRetryTest.excludeBatchStatements(ContinuousCqlRequestHandlerRetryTest.idempotentConfig()), DseTestDataProviders.allDseProtocolVersions());
    }

    @DataProvider
    public static Object[][] failureAndNotIdempotent() {
        return TestDataProviders.combine(ContinuousCqlRequestHandlerRetryTest.failure(), ContinuousCqlRequestHandlerRetryTest.excludeBatchStatements(ContinuousCqlRequestHandlerRetryTest.nonIdempotentConfig()), DseTestDataProviders.allDseProtocolVersions());
    }

    @DataProvider
    public static Object[][] allIdempotenceConfigs() {
        return TestDataProviders.combine(ContinuousCqlRequestHandlerRetryTest.excludeBatchStatements(ContinuousCqlRequestHandlerTestBase.allIdempotenceConfigs()), DseTestDataProviders.allDseProtocolVersions());
    }

    private static Object[][] excludeBatchStatements(Object[][] configs) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] config : configs) {
            if (config[1] instanceof BatchStatement) continue;
            result.add(config);
        }
        return (Object[][])result.toArray((T[])new Object[0][]);
    }

    private static abstract class FailureScenario {
        private final Class<? extends Throwable> expectedExceptionClass;
        final DefaultNodeMetric errorMetric;
        final DefaultNodeMetric retryMetric;
        final DefaultNodeMetric ignoreMetric;

        FailureScenario(Class<? extends Throwable> expectedExceptionClass, DefaultNodeMetric errorMetric, DefaultNodeMetric retryMetric, DefaultNodeMetric ignoreMetric) {
            this.expectedExceptionClass = expectedExceptionClass;
            this.errorMetric = errorMetric;
            this.retryMetric = retryMetric;
            this.ignoreMetric = ignoreMetric;
        }

        abstract void mockRequestError(RequestHandlerTestHarness.Builder var1, Node var2);

        abstract void mockRetryPolicyVerdict(RetryPolicy var1, RetryVerdict var2);
    }
}

