/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph.predicates;

import com.datastax.dse.driver.api.core.graph.predicates.Search;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SearchTest {
    @Test
    public void testToken() {
        P p = Search.token((String)"needle");
        Assertions.assertThat((boolean)p.test((Object)"needle")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"This is a needle in a haystack")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"This is just the haystack")).isFalse();
    }

    @Test
    public void testPrefix() {
        P p = Search.prefix((String)"abcd");
        Assertions.assertThat((boolean)p.test((Object)"abcd")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"abcdefg hijkl")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"zabcd")).isFalse();
    }

    @Test
    public void testTokenPrefix() {
        P p = Search.tokenPrefix((String)"abcd");
        Assertions.assertThat((boolean)p.test((Object)"abcd")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"abcdefg hijkl")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"z abcd")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"ab cd")).isFalse();
    }

    @Test
    public void testRegex() {
        P p = Search.regex((String)"(foo|bar)");
        Assertions.assertThat((boolean)p.test((Object)"foo")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"bar")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo bar")).isFalse();
    }

    @Test
    public void testTokenRegex() {
        P p = Search.tokenRegex((String)"(foo|bar)");
        Assertions.assertThat((boolean)p.test((Object)"foo")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"bar")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo bar")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo bar qix")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"qix")).isFalse();
    }

    @Test
    public void testPhrase() {
        P p = Search.phrase((String)"Hello world", (int)2);
        Assertions.assertThat((boolean)p.test((Object)"Hello World")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"Hello Big World")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"Hello Big Wild World")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"Hello The Big Wild World")).isFalse();
        Assertions.assertThat((boolean)p.test((Object)"Goodbye world")).isFalse();
    }

    @Test
    public void testPhraseFragment() {
        P p = Search.phrase((String)"a b", (int)0);
        Assertions.assertThat((boolean)p.test((Object)"a b")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"a")).isFalse();
        Assertions.assertThat((boolean)p.test((Object)"b")).isFalse();
    }

    @Test
    public void testFuzzy() {
        P p = Search.fuzzy((String)"abc", (int)1);
        Assertions.assertThat((boolean)p.test((Object)"abcd")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"ab")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"abce")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"abdc")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"badc")).isFalse();
        Assertions.assertThat((boolean)Search.tokenFuzzy((String)"ca", (int)2).test((Object)"abc")).isFalse();
    }

    @Test
    public void testTokenFuzzy() {
        P p = Search.tokenFuzzy((String)"abc", (int)1);
        Assertions.assertThat((boolean)p.test((Object)"foo abcd")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo ab")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo abce")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo abdc")).isTrue();
        Assertions.assertThat((boolean)p.test((Object)"foo badc")).isFalse();
        Assertions.assertThat((boolean)Search.tokenFuzzy((String)"ca", (int)2).test((Object)"abc 123")).isFalse();
    }
}

