/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;

public class ByteBufUtil {
    public static ByteBuffer toByteBuffer(ByteBuf buffer) {
        if (buffer.isDirect()) {
            return buffer.nioBuffer();
        }
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), bytes);
        return ByteBuffer.wrap(bytes);
    }

    static ByteBuf toByteBuf(ByteBuffer buffer) {
        return Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    public static ByteBuffer readBytes(ByteBuf nettyBuf, int size) {
        ByteBuffer res = ByteBuffer.allocate(size);
        nettyBuf.readBytes(res);
        res.flip();
        return res;
    }
}

