/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.cleanrooms;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.cleanrooms.CleanRoomNotebookTaskRun;
import com.databricks.sdk.service.cleanrooms.CleanRoomTaskRunsImpl;
import com.databricks.sdk.service.cleanrooms.CleanRoomTaskRunsService;
import com.databricks.sdk.service.cleanrooms.ListCleanRoomNotebookTaskRunsRequest;
import com.databricks.sdk.service.cleanrooms.ListCleanRoomNotebookTaskRunsResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CleanRoomTaskRunsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRoomTaskRunsAPI.class);
    private final CleanRoomTaskRunsService impl;

    public CleanRoomTaskRunsAPI(ApiClient apiClient) {
        this.impl = new CleanRoomTaskRunsImpl(apiClient);
    }

    public CleanRoomTaskRunsAPI(CleanRoomTaskRunsService mock) {
        this.impl = mock;
    }

    public Iterable<CleanRoomNotebookTaskRun> list(String cleanRoomName) {
        return this.list(new ListCleanRoomNotebookTaskRunsRequest().setCleanRoomName(cleanRoomName));
    }

    public Iterable<CleanRoomNotebookTaskRun> list(ListCleanRoomNotebookTaskRunsRequest request) {
        return new Paginator(request, this.impl::list, ListCleanRoomNotebookTaskRunsResponse::getRuns, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CleanRoomTaskRunsService impl() {
        return this.impl;
    }
}

