/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.ConnectionInfo;
import com.databricks.sdk.service.catalog.ConnectionsImpl;
import com.databricks.sdk.service.catalog.ConnectionsService;
import com.databricks.sdk.service.catalog.CreateConnection;
import com.databricks.sdk.service.catalog.DeleteConnectionRequest;
import com.databricks.sdk.service.catalog.GetConnectionRequest;
import com.databricks.sdk.service.catalog.ListConnectionsRequest;
import com.databricks.sdk.service.catalog.ListConnectionsResponse;
import com.databricks.sdk.service.catalog.UpdateConnection;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConnectionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionsAPI.class);
    private final ConnectionsService impl;

    public ConnectionsAPI(ApiClient apiClient) {
        this.impl = new ConnectionsImpl(apiClient);
    }

    public ConnectionsAPI(ConnectionsService mock) {
        this.impl = mock;
    }

    public ConnectionInfo create(CreateConnection request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteConnectionRequest().setName(name));
    }

    public void delete(DeleteConnectionRequest request) {
        this.impl.delete(request);
    }

    public ConnectionInfo get(String name) {
        return this.get(new GetConnectionRequest().setName(name));
    }

    public ConnectionInfo get(GetConnectionRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ConnectionInfo> list(ListConnectionsRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::list, ListConnectionsResponse::getConnections, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConnectionInfo update(UpdateConnection request) {
        return this.impl.update(request);
    }

    public ConnectionsService impl() {
        return this.impl;
    }
}

