/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.billing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.billing.BudgetPolicy;
import com.databricks.sdk.service.billing.BudgetPolicyService;
import com.databricks.sdk.service.billing.CreateBudgetPolicyRequest;
import com.databricks.sdk.service.billing.DeleteBudgetPolicyRequest;
import com.databricks.sdk.service.billing.GetBudgetPolicyRequest;
import com.databricks.sdk.service.billing.ListBudgetPoliciesRequest;
import com.databricks.sdk.service.billing.ListBudgetPoliciesResponse;
import com.databricks.sdk.service.billing.UpdateBudgetPolicyRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.UUID;

@Generated
class BudgetPolicyImpl
implements BudgetPolicyService {
    private final ApiClient apiClient;

    public BudgetPolicyImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public BudgetPolicy create(CreateBudgetPolicyRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budget-policies", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            if (request.getRequestId() == null || request.getRequestId().isEmpty()) {
                request.setRequestId(UUID.randomUUID().toString());
            }
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, BudgetPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteBudgetPolicyRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budget-policies/%s", this.apiClient.configuredAccountID(), request.getPolicyId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public BudgetPolicy get(GetBudgetPolicyRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budget-policies/%s", this.apiClient.configuredAccountID(), request.getPolicyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, BudgetPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListBudgetPoliciesResponse list(ListBudgetPoliciesRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budget-policies", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListBudgetPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public BudgetPolicy update(UpdateBudgetPolicyRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budget-policies/%s", this.apiClient.configuredAccountID(), request.getPolicyId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, BudgetPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

