/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.apps;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.apps.App;
import com.databricks.sdk.service.apps.AppDeployment;
import com.databricks.sdk.service.apps.AppPermissions;
import com.databricks.sdk.service.apps.AppPermissionsRequest;
import com.databricks.sdk.service.apps.AppUpdate;
import com.databricks.sdk.service.apps.AppsService;
import com.databricks.sdk.service.apps.AsyncUpdateAppRequest;
import com.databricks.sdk.service.apps.CreateAppDeploymentRequest;
import com.databricks.sdk.service.apps.CreateAppRequest;
import com.databricks.sdk.service.apps.DeleteAppRequest;
import com.databricks.sdk.service.apps.GetAppDeploymentRequest;
import com.databricks.sdk.service.apps.GetAppPermissionLevelsRequest;
import com.databricks.sdk.service.apps.GetAppPermissionLevelsResponse;
import com.databricks.sdk.service.apps.GetAppPermissionsRequest;
import com.databricks.sdk.service.apps.GetAppRequest;
import com.databricks.sdk.service.apps.GetAppUpdateRequest;
import com.databricks.sdk.service.apps.ListAppDeploymentsRequest;
import com.databricks.sdk.service.apps.ListAppDeploymentsResponse;
import com.databricks.sdk.service.apps.ListAppsRequest;
import com.databricks.sdk.service.apps.ListAppsResponse;
import com.databricks.sdk.service.apps.StartAppRequest;
import com.databricks.sdk.service.apps.StopAppRequest;
import com.databricks.sdk.service.apps.UpdateAppRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AppsImpl
implements AppsService {
    private final ApiClient apiClient;

    public AppsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public App create(CreateAppRequest request) {
        String path = "/api/2.0/apps";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getApp()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, App.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppUpdate createUpdate(AsyncUpdateAppRequest request) {
        String path = String.format("/api/2.0/apps/%s/update", request.getAppName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AppUpdate.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public App delete(DeleteAppRequest request) {
        String path = String.format("/api/2.0/apps/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, App.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppDeployment deploy(CreateAppDeploymentRequest request) {
        String path = String.format("/api/2.0/apps/%s/deployments", request.getAppName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getAppDeployment()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AppDeployment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public App get(GetAppRequest request) {
        String path = String.format("/api/2.0/apps/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, App.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppDeployment getDeployment(GetAppDeploymentRequest request) {
        String path = String.format("/api/2.0/apps/%s/deployments/%s", request.getAppName(), request.getDeploymentId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AppDeployment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetAppPermissionLevelsResponse getPermissionLevels(GetAppPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s/permissionLevels", request.getAppName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetAppPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppPermissions getPermissions(GetAppPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s", request.getAppName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AppPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppUpdate getUpdate(GetAppUpdateRequest request) {
        String path = String.format("/api/2.0/apps/%s/update", request.getAppName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AppUpdate.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAppsResponse list(ListAppsRequest request) {
        String path = "/api/2.0/apps";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAppsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAppDeploymentsResponse listDeployments(ListAppDeploymentsRequest request) {
        String path = String.format("/api/2.0/apps/%s/deployments", request.getAppName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAppDeploymentsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppPermissions setPermissions(AppPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s", request.getAppName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AppPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public App start(StartAppRequest request) {
        String path = String.format("/api/2.0/apps/%s/start", request.getName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, App.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public App stop(StopAppRequest request) {
        String path = String.format("/api/2.0/apps/%s/stop", request.getName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, App.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public App update(UpdateAppRequest request) {
        String path = String.format("/api/2.0/apps/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getApp()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, App.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AppPermissions updatePermissions(AppPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s", request.getAppName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AppPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

