/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.oauth.Consent;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class OAuthClient {
    private final String clientId;
    private final String clientSecret;
    private final String host;
    private final String redirectUrl;
    private final List<String> scopes;
    private final String tokenUrl;
    private final String authUrl;
    private final HttpClient hc;
    private final SecureRandom random = new SecureRandom();
    private final boolean isAws;
    private final boolean isAzure;
    private final OpenIDConnectEndpoints openIDConnectEndpoints;
    private final Optional<Duration> browserTimeout;

    private OAuthClient(Builder b) throws IOException {
        this.clientId = Objects.requireNonNull(b.clientId);
        this.clientSecret = b.clientSecret;
        this.redirectUrl = Objects.requireNonNull(b.redirectUrl);
        this.host = b.host;
        this.hc = b.hc;
        DatabricksConfig config = new DatabricksConfig().setHost(b.host).setAccountId(b.accountId).resolve();
        this.openIDConnectEndpoints = b.openIDConnectEndpoints;
        if (this.openIDConnectEndpoints == null) {
            throw new DatabricksException(b.host + " does not support OAuth");
        }
        this.isAws = config.isAws();
        this.isAzure = config.isAzure();
        this.tokenUrl = this.openIDConnectEndpoints.getTokenEndpoint();
        this.authUrl = this.openIDConnectEndpoints.getAuthorizationEndpoint();
        this.browserTimeout = b.browserTimeout;
        this.scopes = b.scopes;
    }

    public String getHost() {
        return this.host;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OpenIDConnectEndpoints getOidcEndpoints() {
        return this.openIDConnectEndpoints;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean isAws() {
        return this.isAws;
    }

    public boolean isAzure() {
        return this.isAzure;
    }

    private String tokenUrlSafe(int byteLength) {
        byte[] bytes = new byte[byteLength];
        this.random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private static byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DatabricksException("SHA-256 algorithm not found", e);
        }
    }

    protected static String urlEncode(String urlBase, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return urlBase;
        }
        String queryParams = params.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> OAuthClient.encodeParam((String)entry.getKey()) + "=" + OAuthClient.encodeParam((String)entry.getValue())).collect(Collectors.joining("&"));
        String separator = urlBase.contains("?") ? "&" : "?";
        return urlBase + separator + queryParams;
    }

    private static String encodeParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
    }

    public Consent initiateConsent() throws MalformedURLException {
        if (this.authUrl == null) {
            throw new DatabricksException("Authorization URL is not configured. OAuth endpoints may not be available.");
        }
        String state = this.tokenUrlSafe(16);
        String verifier = this.tokenUrlSafe(32);
        byte[] digest = OAuthClient.sha256(verifier.getBytes(StandardCharsets.UTF_8));
        String challenge = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("response_type", "code");
        params.put("client_id", this.clientId);
        params.put("redirect_uri", this.redirectUrl);
        params.put("scope", String.join((CharSequence)" ", this.scopes));
        params.put("state", state);
        params.put("code_challenge", challenge);
        params.put("code_challenge_method", "S256");
        String url = OAuthClient.urlEncode(this.authUrl, params);
        return new Consent.Builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withAuthUrl(url).withTokenUrl(this.tokenUrl).withRedirectUrl(this.redirectUrl).withState(state).withVerifier(verifier).withHttpClient(this.hc).withBrowserTimeout(this.browserTimeout).build();
    }

    public static class Builder {
        private String host;
        private String clientId;
        private String redirectUrl;
        private List<String> scopes;
        private String clientSecret;
        private HttpClient hc;
        private String accountId;
        private Optional<Duration> browserTimeout = Optional.empty();
        private OpenIDConnectEndpoints openIDConnectEndpoints;

        public Builder withHttpClient(HttpClient hc) {
            this.hc = hc;
            return this;
        }

        public Builder withOpenIDConnectEndpoints(OpenIDConnectEndpoints openIDConnectEndpoints) {
            this.openIDConnectEndpoints = openIDConnectEndpoints;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder withScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public OAuthClient build() throws IOException {
            return new OAuthClient(this);
        }

        public Builder withAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder withBrowserTimeout(Duration browserTimeout) {
            this.browserTimeout = Optional.of(browserTimeout);
            return this;
        }
    }
}

