/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.commons;

import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.ProxyConfig;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.utils.CustomCloseInputStream;
import com.databricks.sdk.core.utils.ProxyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsHttpClient.class);
    private final CloseableHttpClient hc;

    private CommonsHttpClient(Builder builder) {
        int timeoutSeconds = 300;
        if (builder.databricksConfig != null && builder.databricksConfig.getHttpTimeoutSeconds() != null) {
            timeoutSeconds = builder.databricksConfig.getHttpTimeoutSeconds();
        }
        if (builder.timeoutSeconds != null) {
            timeoutSeconds = builder.timeoutSeconds;
        }
        int timeout = timeoutSeconds * 1000;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(this.makeRequestConfig(timeout));
        if (builder.proxyConfig != null) {
            ProxyUtils.setupProxy(builder.proxyConfig, httpClientBuilder);
        }
        if (builder.sslSocketFactory != null) {
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)builder.sslSocketFactory);
        }
        if (builder.connectionManager != null) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)builder.connectionManager);
        } else {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(100);
            connectionManager.setDefaultMaxPerRoute(20);
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        if (builder.requestRetryHandler != null) {
            httpClientBuilder.setRetryHandler(builder.requestRetryHandler);
        }
        this.hc = httpClientBuilder.build();
    }

    private RequestConfig makeRequestConfig(int timeout) {
        return RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
    }

    @Override
    public Response execute(Request in) throws IOException {
        HttpUriRequest request = this.transformRequest(in);
        boolean handleRedirects = in.getRedirectionBehavior().orElse(true);
        if (!handleRedirects) {
            request.getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        }
        in.getHeaders().forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        BasicHttpContext context = new BasicHttpContext();
        CloseableHttpResponse response = this.hc.execute(request, (HttpContext)context);
        return this.computeResponse(in, (HttpContext)context, response);
    }

    private URL getTargetUrl(HttpContext context) {
        try {
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            URI uri = new URI(request.getRequestLine().getUri());
            uri = new URI(targetHost.getSchemeName(), null, targetHost.getHostName(), targetHost.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new DatabricksException("Unable to get target URL", e);
        }
    }

    /*
     * Loose catch block
     */
    private Response computeResponse(Request in, HttpContext context, CloseableHttpResponse response) throws IOException {
        boolean streamResponse;
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        Map<String, List<String>> hs = Arrays.stream(response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
        URL url = this.getTargetUrl(context);
        if (entity == null) {
            response.close();
            return new Response(in, url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs);
        }
        boolean bl = streamResponse = in.getHeaders().containsKey("Accept") && !ContentType.APPLICATION_JSON.getMimeType().equals(in.getHeaders().get("Accept")) && !ContentType.APPLICATION_JSON.getMimeType().equals(response.getFirstHeader("Content-Type").getValue());
        if (streamResponse) {
            CustomCloseInputStream inputStream = new CustomCloseInputStream(entity.getContent(), () -> {
                try {
                    response.close();
                }
                catch (Exception e) {
                    throw new DatabricksException("Unable to close connection", e);
                }
            });
            return new Response(in, url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, inputStream);
        }
        try {
            try (InputStream inputStream = entity.getContent();){
                String body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                Response response2 = new Response(in, url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, body);
                return response2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            response.close();
        }
    }

    private HttpUriRequest transformRequest(Request in) {
        switch (in.getMethod()) {
            case "GET": {
                return new HttpGet(in.getUri());
            }
            case "HEAD": {
                return new HttpHead(in.getUri());
            }
            case "DELETE": {
                return new HttpDelete(in.getUri());
            }
            case "POST": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPost(in.getUri()), in);
            }
            case "PUT": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPut(in.getUri()), in);
            }
            case "PATCH": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPatch(in.getUri()), in);
            }
        }
        throw new IllegalArgumentException("Unknown method: " + in.getMethod());
    }

    private HttpRequestBase withEntity(HttpEntityEnclosingRequestBase request, Request in) {
        if (in.isBodyString()) {
            request.setEntity((HttpEntity)new StringEntity(in.getBodyString(), StandardCharsets.UTF_8));
        } else if (in.isBodyStreaming()) {
            request.setEntity((HttpEntity)new InputStreamEntity(in.getBodyStream()));
        } else {
            LOG.warn("withEntity called with a request with no body, so no request entity will be set. URI: {}", (Object)in.getUri());
        }
        return request;
    }

    public static class Builder {
        private DatabricksConfig databricksConfig;
        private Integer timeoutSeconds;
        private ProxyConfig proxyConfig;
        private SSLConnectionSocketFactory sslSocketFactory;
        private PoolingHttpClientConnectionManager connectionManager;
        private HttpRequestRetryHandler requestRetryHandler;

        public Builder withDatabricksConfig(DatabricksConfig databricksConfig) {
            this.databricksConfig = databricksConfig;
            return this;
        }

        public Builder withTimeoutSeconds(int timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder withProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder withSslSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder withConnectionManager(PoolingHttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        public Builder withRequestRetryHandler(HttpRequestRetryHandler requestRetryHandler) {
            this.requestRetryHandler = requestRetryHandler;
            return this;
        }

        public CommonsHttpClient build() {
            return new CommonsHttpClient(this);
        }
    }
}

