/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.sql.CancelExecutionRequest;
import com.databricks.sdk.service.sql.ExecuteStatementRequest;
import com.databricks.sdk.service.sql.GetStatementRequest;
import com.databricks.sdk.service.sql.GetStatementResultChunkNRequest;
import com.databricks.sdk.service.sql.ResultData;
import com.databricks.sdk.service.sql.StatementExecutionService;
import com.databricks.sdk.service.sql.StatementResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class StatementExecutionImpl
implements StatementExecutionService {
    private final ApiClient apiClient;

    public StatementExecutionImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void cancelExecution(CancelExecutionRequest request) {
        String path = String.format("/api/2.0/sql/statements/%s/cancel", request.getStatementId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public StatementResponse executeStatement(ExecuteStatementRequest request) {
        String path = "/api/2.0/sql/statements/";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, StatementResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public StatementResponse getStatement(GetStatementRequest request) {
        String path = String.format("/api/2.0/sql/statements/%s", request.getStatementId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, StatementResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResultData getStatementResultChunkN(GetStatementResultChunkNRequest request) {
        String path = String.format("/api/2.0/sql/statements/%s/result/chunks/%s", request.getStatementId(), request.getChunkIndex());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ResultData.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

