/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.provisioning.CreateCustomerManagedKeyRequest;
import com.databricks.sdk.service.provisioning.CustomerManagedKey;
import com.databricks.sdk.service.provisioning.DeleteEncryptionKeyRequest;
import com.databricks.sdk.service.provisioning.EncryptionKeysService;
import com.databricks.sdk.service.provisioning.GetEncryptionKeyRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class EncryptionKeysImpl
implements EncryptionKeysService {
    private final ApiClient apiClient;

    public EncryptionKeysImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CustomerManagedKey create(CreateCustomerManagedKeyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CustomerManagedKey.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteEncryptionKeyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys/%s", this.apiClient.configuredAccountID(), request.getCustomerManagedKeyId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CustomerManagedKey get(GetEncryptionKeyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys/%s", this.apiClient.configuredAccountID(), request.getCustomerManagedKeyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CustomerManagedKey.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<CustomerManagedKey> list() {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys", this.apiClient.configuredAccountID());
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, CustomerManagedKey.class);
    }
}

