/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.pipelines;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.pipelines.CreatePipeline;
import com.databricks.sdk.service.pipelines.CreatePipelineResponse;
import com.databricks.sdk.service.pipelines.DeletePipelineRequest;
import com.databricks.sdk.service.pipelines.EditPipeline;
import com.databricks.sdk.service.pipelines.GetPipelinePermissionLevelsRequest;
import com.databricks.sdk.service.pipelines.GetPipelinePermissionLevelsResponse;
import com.databricks.sdk.service.pipelines.GetPipelinePermissionsRequest;
import com.databricks.sdk.service.pipelines.GetPipelineRequest;
import com.databricks.sdk.service.pipelines.GetPipelineResponse;
import com.databricks.sdk.service.pipelines.GetUpdateRequest;
import com.databricks.sdk.service.pipelines.GetUpdateResponse;
import com.databricks.sdk.service.pipelines.ListPipelineEventsRequest;
import com.databricks.sdk.service.pipelines.ListPipelineEventsResponse;
import com.databricks.sdk.service.pipelines.ListPipelinesRequest;
import com.databricks.sdk.service.pipelines.ListPipelinesResponse;
import com.databricks.sdk.service.pipelines.ListUpdatesRequest;
import com.databricks.sdk.service.pipelines.ListUpdatesResponse;
import com.databricks.sdk.service.pipelines.PipelineEvent;
import com.databricks.sdk.service.pipelines.PipelinePermissions;
import com.databricks.sdk.service.pipelines.PipelinePermissionsRequest;
import com.databricks.sdk.service.pipelines.PipelineState;
import com.databricks.sdk.service.pipelines.PipelineStateInfo;
import com.databricks.sdk.service.pipelines.PipelinesImpl;
import com.databricks.sdk.service.pipelines.PipelinesService;
import com.databricks.sdk.service.pipelines.StartUpdate;
import com.databricks.sdk.service.pipelines.StartUpdateResponse;
import com.databricks.sdk.service.pipelines.StopRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class PipelinesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinesAPI.class);
    private final PipelinesService impl;

    public PipelinesAPI(ApiClient apiClient) {
        this.impl = new PipelinesImpl(apiClient);
    }

    public PipelinesAPI(PipelinesService mock) {
        this.impl = mock;
    }

    public GetPipelineResponse waitGetPipelineIdle(String pipelineId) throws TimeoutException {
        return this.waitGetPipelineIdle(pipelineId, Duration.ofMinutes(20L), null);
    }

    public GetPipelineResponse waitGetPipelineIdle(String pipelineId, Duration timeout, Consumer<GetPipelineResponse> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<PipelineState> targetStates = Arrays.asList(PipelineState.IDLE);
        List<PipelineState> failureStates = Arrays.asList(PipelineState.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            GetPipelineResponse poll = this.get(new GetPipelineRequest().setPipelineId(pipelineId));
            PipelineState status = poll.getState();
            statusMessage = poll.getCause();
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach IDLE, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("pipelineId=%s", pipelineId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public CreatePipelineResponse create(CreatePipeline request) {
        return this.impl.create(request);
    }

    public void delete(String pipelineId) {
        this.delete(new DeletePipelineRequest().setPipelineId(pipelineId));
    }

    public void delete(DeletePipelineRequest request) {
        this.impl.delete(request);
    }

    public GetPipelineResponse get(String pipelineId) {
        return this.get(new GetPipelineRequest().setPipelineId(pipelineId));
    }

    public GetPipelineResponse get(GetPipelineRequest request) {
        return this.impl.get(request);
    }

    public GetPipelinePermissionLevelsResponse getPermissionLevels(String pipelineId) {
        return this.getPermissionLevels(new GetPipelinePermissionLevelsRequest().setPipelineId(pipelineId));
    }

    public GetPipelinePermissionLevelsResponse getPermissionLevels(GetPipelinePermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public PipelinePermissions getPermissions(String pipelineId) {
        return this.getPermissions(new GetPipelinePermissionsRequest().setPipelineId(pipelineId));
    }

    public PipelinePermissions getPermissions(GetPipelinePermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public GetUpdateResponse getUpdate(String pipelineId, String updateId) {
        return this.getUpdate(new GetUpdateRequest().setPipelineId(pipelineId).setUpdateId(updateId));
    }

    public GetUpdateResponse getUpdate(GetUpdateRequest request) {
        return this.impl.getUpdate(request);
    }

    public Iterable<PipelineEvent> listPipelineEvents(String pipelineId) {
        return this.listPipelineEvents(new ListPipelineEventsRequest().setPipelineId(pipelineId));
    }

    public Iterable<PipelineEvent> listPipelineEvents(ListPipelineEventsRequest request) {
        return new Paginator(request, this.impl::listPipelineEvents, ListPipelineEventsResponse::getEvents, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<PipelineStateInfo> listPipelines(ListPipelinesRequest request) {
        return new Paginator(request, this.impl::listPipelines, ListPipelinesResponse::getStatuses, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ListUpdatesResponse listUpdates(String pipelineId) {
        return this.listUpdates(new ListUpdatesRequest().setPipelineId(pipelineId));
    }

    public ListUpdatesResponse listUpdates(ListUpdatesRequest request) {
        return this.impl.listUpdates(request);
    }

    public PipelinePermissions setPermissions(PipelinePermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public StartUpdateResponse startUpdate(StartUpdate request) {
        return this.impl.startUpdate(request);
    }

    public Wait<GetPipelineResponse, Void> stop(StopRequest request) {
        this.impl.stop(request);
        return new Wait<GetPipelineResponse, Void>((timeout, callback) -> this.waitGetPipelineIdle(request.getPipelineId(), timeout, callback));
    }

    public void update(EditPipeline request) {
        this.impl.update(request);
    }

    public PipelinePermissions updatePermissions(PipelinePermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public PipelinesService impl() {
        return this.impl;
    }
}

