/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.marketplace.ConsumerProvidersImpl;
import com.databricks.sdk.service.marketplace.ConsumerProvidersService;
import com.databricks.sdk.service.marketplace.GetProviderRequest;
import com.databricks.sdk.service.marketplace.GetProviderResponse;
import com.databricks.sdk.service.marketplace.ListProvidersRequest;
import com.databricks.sdk.service.marketplace.ListProvidersResponse;
import com.databricks.sdk.service.marketplace.ProviderInfo;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConsumerProvidersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerProvidersAPI.class);
    private final ConsumerProvidersService impl;

    public ConsumerProvidersAPI(ApiClient apiClient) {
        this.impl = new ConsumerProvidersImpl(apiClient);
    }

    public ConsumerProvidersAPI(ConsumerProvidersService mock) {
        this.impl = mock;
    }

    public GetProviderResponse get(String id) {
        return this.get(new GetProviderRequest().setId(id));
    }

    public GetProviderResponse get(GetProviderRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ProviderInfo> list(ListProvidersRequest request) {
        return new Paginator(request, this.impl::list, ListProvidersResponse::getProviders, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConsumerProvidersService impl() {
        return this.impl;
    }
}

