/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sharing.AuthenticationType;
import com.databricks.sdk.service.sharing.CreateRecipient;
import com.databricks.sdk.service.sharing.DeleteRecipientRequest;
import com.databricks.sdk.service.sharing.GetRecipientRequest;
import com.databricks.sdk.service.sharing.GetRecipientSharePermissionsResponse;
import com.databricks.sdk.service.sharing.ListRecipientsRequest;
import com.databricks.sdk.service.sharing.RecipientInfo;
import com.databricks.sdk.service.sharing.RecipientsImpl;
import com.databricks.sdk.service.sharing.RecipientsService;
import com.databricks.sdk.service.sharing.RotateRecipientToken;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.UpdateRecipient;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class RecipientsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientsAPI.class);
    private final RecipientsService impl;

    public RecipientsAPI(ApiClient apiClient) {
        this.impl = new RecipientsImpl(apiClient);
    }

    public RecipientsAPI(RecipientsService mock) {
        this.impl = mock;
    }

    public RecipientInfo create(String name, AuthenticationType authenticationType) {
        return this.create(new CreateRecipient().setName(name).setAuthenticationType(authenticationType));
    }

    public RecipientInfo create(CreateRecipient request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteRecipientRequest().setName(name));
    }

    public void delete(DeleteRecipientRequest request) {
        this.impl.delete(request);
    }

    public RecipientInfo get(String name) {
        return this.get(new GetRecipientRequest().setName(name));
    }

    public RecipientInfo get(GetRecipientRequest request) {
        return this.impl.get(request);
    }

    public Iterable<RecipientInfo> list(ListRecipientsRequest request) {
        return this.impl.list(request).getRecipients();
    }

    public RecipientInfo rotateToken(String name, long existingTokenExpireInSeconds) {
        return this.rotateToken(new RotateRecipientToken().setName(name).setExistingTokenExpireInSeconds(existingTokenExpireInSeconds));
    }

    public RecipientInfo rotateToken(RotateRecipientToken request) {
        return this.impl.rotateToken(request);
    }

    public GetRecipientSharePermissionsResponse sharePermissions(String name) {
        return this.sharePermissions(new SharePermissionsRequest().setName(name));
    }

    public GetRecipientSharePermissionsResponse sharePermissions(SharePermissionsRequest request) {
        return this.impl.sharePermissions(request);
    }

    public void update(String name) {
        this.update(new UpdateRecipient().setName(name));
    }

    public void update(UpdateRecipient request) {
        this.impl.update(request);
    }

    public RecipientsService impl() {
        return this.impl;
    }
}

