/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.files;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.files.DeleteFileRequest;
import com.databricks.sdk.service.files.DownloadRequest;
import com.databricks.sdk.service.files.DownloadResponse;
import com.databricks.sdk.service.files.FileInfo;
import com.databricks.sdk.service.files.FilesImpl;
import com.databricks.sdk.service.files.FilesService;
import com.databricks.sdk.service.files.GetStatusRequest;
import com.databricks.sdk.service.files.UploadRequest;
import com.databricks.sdk.support.Generated;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FilesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FilesAPI.class);
    private final FilesService impl;

    public FilesAPI(ApiClient apiClient) {
        this.impl = new FilesImpl(apiClient);
    }

    public FilesAPI(FilesService mock) {
        this.impl = mock;
    }

    public void delete(String filePath) {
        this.delete(new DeleteFileRequest().setFilePath(filePath));
    }

    public void delete(DeleteFileRequest request) {
        this.impl.delete(request);
    }

    public DownloadResponse download(String filePath) {
        return this.download(new DownloadRequest().setFilePath(filePath));
    }

    public DownloadResponse download(DownloadRequest request) {
        return this.impl.download(request);
    }

    public FileInfo getStatus(String path) {
        return this.getStatus(new GetStatusRequest().setPath(path));
    }

    public FileInfo getStatus(GetStatusRequest request) {
        return this.impl.getStatus(request);
    }

    public void upload(String filePath, InputStream contents) {
        this.upload(new UploadRequest().setFilePath(filePath).setContents(contents));
    }

    public void upload(UploadRequest request) {
        this.impl.upload(request);
    }

    public FilesService impl() {
        return this.impl;
    }
}

