/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateSchema;
import com.databricks.sdk.service.catalog.DeleteSchemaRequest;
import com.databricks.sdk.service.catalog.GetSchemaRequest;
import com.databricks.sdk.service.catalog.ListSchemasRequest;
import com.databricks.sdk.service.catalog.SchemaInfo;
import com.databricks.sdk.service.catalog.SchemasImpl;
import com.databricks.sdk.service.catalog.SchemasService;
import com.databricks.sdk.service.catalog.UpdateSchema;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class SchemasAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SchemasAPI.class);
    private final SchemasService impl;

    public SchemasAPI(ApiClient apiClient) {
        this.impl = new SchemasImpl(apiClient);
    }

    public SchemasAPI(SchemasService mock) {
        this.impl = mock;
    }

    public SchemaInfo create(String name, String catalogName) {
        return this.create(new CreateSchema().setName(name).setCatalogName(catalogName));
    }

    public SchemaInfo create(CreateSchema request) {
        return this.impl.create(request);
    }

    public void delete(String fullName) {
        this.delete(new DeleteSchemaRequest().setFullName(fullName));
    }

    public void delete(DeleteSchemaRequest request) {
        this.impl.delete(request);
    }

    public SchemaInfo get(String fullName) {
        return this.get(new GetSchemaRequest().setFullName(fullName));
    }

    public SchemaInfo get(GetSchemaRequest request) {
        return this.impl.get(request);
    }

    public Iterable<SchemaInfo> list(String catalogName) {
        return this.list(new ListSchemasRequest().setCatalogName(catalogName));
    }

    public Iterable<SchemaInfo> list(ListSchemasRequest request) {
        return this.impl.list(request).getSchemas();
    }

    public SchemaInfo update(String fullName) {
        return this.update(new UpdateSchema().setFullName(fullName));
    }

    public SchemaInfo update(UpdateSchema request) {
        return this.impl.update(request);
    }

    public SchemasService impl() {
        return this.impl;
    }
}

