/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.ConfigAttribute;
import com.databricks.sdk.core.DatabricksConfig;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;

class ConfigAttributeAccessor {
    private ConfigAttribute configAttribute;
    private Field field;

    public ConfigAttributeAccessor(ConfigAttribute configAttribute, Field field) {
        this.configAttribute = configAttribute;
        this.field = field;
    }

    public String getName() {
        return this.configAttribute.value();
    }

    public String getEnvVariable() {
        return this.configAttribute.env();
    }

    public Boolean isSensitive() {
        return this.configAttribute.sensitive();
    }

    public String getEnv(Map<String, String> getEnv) {
        if (this.configAttribute.env().isEmpty()) {
            return "";
        }
        return getEnv.get(this.configAttribute.env());
    }

    public void setValueOnConfig(DatabricksConfig cfg, String value) throws IllegalAccessException {
        this.field.setAccessible(true);
        if (this.field.getType() == String.class) {
            this.field.set(cfg, value);
        } else if (this.field.getType() == Integer.TYPE) {
            this.field.set(cfg, Integer.parseInt(value));
        } else if (this.field.getType() == Boolean.TYPE) {
            this.field.set(cfg, Boolean.parseBoolean(value));
        }
        this.field.setAccessible(false);
    }

    public Object getValueFromConfig(DatabricksConfig cfg) throws IllegalAccessException {
        this.field.setAccessible(true);
        Object value = this.field.get(cfg);
        this.field.setAccessible(false);
        return value;
    }

    public String getAuthType() {
        return this.configAttribute.auth();
    }

    public String toString() {
        String repr = this.configAttribute.value();
        if (!Objects.equals(this.configAttribute.env(), "")) {
            repr = repr + "(env: " + this.configAttribute.env() + ")";
        }
        return repr;
    }

    public String getAsString(Object value) {
        String valueToString = value.toString();
        return valueToString;
    }
}

