/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.workspace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.workspace.Delete;
import com.databricks.internal.sdk.service.workspace.ExportRequest;
import com.databricks.internal.sdk.service.workspace.ExportResponse;
import com.databricks.internal.sdk.service.workspace.GetStatusRequest;
import com.databricks.internal.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsRequest;
import com.databricks.internal.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsResponse;
import com.databricks.internal.sdk.service.workspace.GetWorkspaceObjectPermissionsRequest;
import com.databricks.internal.sdk.service.workspace.Import;
import com.databricks.internal.sdk.service.workspace.ListResponse;
import com.databricks.internal.sdk.service.workspace.ListWorkspaceRequest;
import com.databricks.internal.sdk.service.workspace.Mkdirs;
import com.databricks.internal.sdk.service.workspace.ObjectInfo;
import com.databricks.internal.sdk.service.workspace.WorkspaceImpl;
import com.databricks.internal.sdk.service.workspace.WorkspaceObjectPermissions;
import com.databricks.internal.sdk.service.workspace.WorkspaceObjectPermissionsRequest;
import com.databricks.internal.sdk.service.workspace.WorkspaceService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class WorkspaceAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceAPI.class);
    private final WorkspaceService impl;

    public WorkspaceAPI(ApiClient apiClient) {
        this.impl = new WorkspaceImpl(apiClient);
    }

    public WorkspaceAPI(WorkspaceService mock) {
        this.impl = mock;
    }

    public void delete(Delete request) {
        this.impl.delete(request);
    }

    public ExportResponse export(String path) {
        return this.export(new ExportRequest().setPath(path));
    }

    public ExportResponse export(ExportRequest request) {
        return this.impl.export(request);
    }

    public GetWorkspaceObjectPermissionLevelsResponse getPermissionLevels(String workspaceObjectType, String workspaceObjectId) {
        return this.getPermissionLevels(new GetWorkspaceObjectPermissionLevelsRequest().setWorkspaceObjectType(workspaceObjectType).setWorkspaceObjectId(workspaceObjectId));
    }

    public GetWorkspaceObjectPermissionLevelsResponse getPermissionLevels(GetWorkspaceObjectPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public WorkspaceObjectPermissions getPermissions(String workspaceObjectType, String workspaceObjectId) {
        return this.getPermissions(new GetWorkspaceObjectPermissionsRequest().setWorkspaceObjectType(workspaceObjectType).setWorkspaceObjectId(workspaceObjectId));
    }

    public WorkspaceObjectPermissions getPermissions(GetWorkspaceObjectPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public ObjectInfo getStatus(String path) {
        return this.getStatus(new GetStatusRequest().setPath(path));
    }

    public ObjectInfo getStatus(GetStatusRequest request) {
        return this.impl.getStatus(request);
    }

    public void importContent(Import request) {
        this.impl.importContent(request);
    }

    public Iterable<ObjectInfo> list(String path) {
        return this.list(new ListWorkspaceRequest().setPath(path));
    }

    public Iterable<ObjectInfo> list(ListWorkspaceRequest request) {
        return new Paginator(request, this.impl::list, ListResponse::getObjects, response -> null);
    }

    public void mkdirs(String path) {
        this.mkdirs(new Mkdirs().setPath(path));
    }

    public void mkdirs(Mkdirs request) {
        this.impl.mkdirs(request);
    }

    public WorkspaceObjectPermissions setPermissions(WorkspaceObjectPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public WorkspaceObjectPermissions updatePermissions(WorkspaceObjectPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public WorkspaceService impl() {
        return this.impl;
    }
}

