/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.linemerge;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateArrays;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.operation.linemerge.LineMergeDirectedEdge;
import com.databricks.internal.jts.operation.linemerge.LineMergeEdge;
import com.databricks.internal.jts.planargraph.Node;
import com.databricks.internal.jts.planargraph.PlanarGraph;

public class LineMergeGraph
extends PlanarGraph {
    public void addEdge(LineString lineString) {
        if (lineString.isEmpty()) {
            return;
        }
        Coordinate[] coordinates = CoordinateArrays.removeRepeatedPoints(lineString.getCoordinates());
        if (coordinates.length <= 1) {
            return;
        }
        Coordinate startCoordinate = coordinates[0];
        Coordinate endCoordinate = coordinates[coordinates.length - 1];
        Node startNode = this.getNode(startCoordinate);
        Node endNode = this.getNode(endCoordinate);
        LineMergeDirectedEdge directedEdge0 = new LineMergeDirectedEdge(startNode, endNode, coordinates[1], true);
        LineMergeDirectedEdge directedEdge1 = new LineMergeDirectedEdge(endNode, startNode, coordinates[coordinates.length - 2], false);
        LineMergeEdge edge = new LineMergeEdge(lineString);
        edge.setDirectedEdges(directedEdge0, directedEdge1);
        this.add(edge);
    }

    private Node getNode(Coordinate coordinate) {
        Node node = this.findNode(coordinate);
        if (node == null) {
            node = new Node(coordinate);
            this.add(node);
        }
        return node;
    }
}

