/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.buffer;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.index.ItemVisitor;
import com.databricks.internal.jts.index.chain.MonotoneChain;
import com.databricks.internal.jts.index.chain.MonotoneChainBuilder;
import com.databricks.internal.jts.index.chain.MonotoneChainSelectAction;
import com.databricks.internal.jts.index.strtree.STRtree;
import java.util.List;

class SegmentMCIndex {
    private STRtree index;

    public SegmentMCIndex(Coordinate[] segs) {
        this.index = this.buildIndex(segs);
    }

    private STRtree buildIndex(Coordinate[] segs) {
        STRtree index = new STRtree();
        List segChains = MonotoneChainBuilder.getChains(segs, segs);
        for (MonotoneChain mc : segChains) {
            index.insert(mc.getEnvelope(), (Object)mc);
        }
        return index;
    }

    public void query(final Envelope env, final MonotoneChainSelectAction action) {
        this.index.query(env, new ItemVisitor(){

            @Override
            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(env, action);
            }
        });
    }
}

