/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.jdbc.api.impl.arrow.ArrowResultChunk;
import com.databricks.jdbc.api.impl.arrow.ChunkDownloadManager;
import com.databricks.jdbc.api.impl.arrow.ChunkLinkDownloadService;
import com.databricks.jdbc.api.impl.arrow.ChunkStatus;
import com.databricks.jdbc.api.impl.arrow.DatabricksCallableTask;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

class ChunkDownloadTask
implements DatabricksCallableTask {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ChunkDownloadTask.class);
    public static final int MAX_RETRIES = 5;
    private static final long RETRY_DELAY_MS = 1500L;
    private final ArrowResultChunk chunk;
    private final IDatabricksHttpClient httpClient;
    private final ChunkDownloadManager chunkDownloader;
    private final IDatabricksConnectionContext connectionContext;
    private final String statementId;
    private final ChunkLinkDownloadService<ArrowResultChunk> linkDownloadService;
    Throwable uncaughtException = null;

    ChunkDownloadTask(ArrowResultChunk chunk, IDatabricksHttpClient httpClient, ChunkDownloadManager chunkDownloader, ChunkLinkDownloadService<ArrowResultChunk> linkDownloadService) {
        this.chunk = chunk;
        this.httpClient = httpClient;
        this.chunkDownloader = chunkDownloader;
        this.connectionContext = DatabricksThreadContextHolder.getConnectionContext();
        this.statementId = DatabricksThreadContextHolder.getStatementId();
        this.linkDownloadService = linkDownloadService;
    }

    @Override
    public Void call() throws DatabricksSQLException, ExecutionException, InterruptedException {
        block14: {
            block13: {
                int retries = 0;
                boolean downloadSuccessful = false;
                DatabricksThreadContextHolder.setConnectionContext(this.connectionContext);
                DatabricksThreadContextHolder.setStatementId(this.statementId);
                try {
                    DatabricksThreadContextHolder.setRetryCount(retries);
                    while (!downloadSuccessful) {
                        try {
                            if (this.chunk.isChunkLinkInvalid()) {
                                ExternalLink link = this.linkDownloadService.getLinkForChunk(this.chunk.getChunkIndex()).get();
                                this.chunk.setChunkLink(link);
                            }
                            this.chunk.downloadData(this.httpClient, this.chunkDownloader.getCompressionCodec(), this.connectionContext != null ? this.connectionContext.getCloudFetchSpeedThreshold() : 0.1);
                            downloadSuccessful = true;
                        }
                        catch (DatabricksSQLException | IOException e) {
                            if (++retries >= 5) {
                                LOGGER.error(e, "Failed to download chunk after %d attempts. Chunk index: %d, Error: %s", 5, this.chunk.getChunkIndex(), e.getMessage());
                                this.chunk.setStatus(ChunkStatus.DOWNLOAD_FAILED);
                                throw new DatabricksSQLException("Failed to download chunk after multiple attempts", e, this.statementId, this.chunk.getChunkIndex(), DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR.name());
                            }
                            LOGGER.warn(String.format("Retry attempt %d for chunk index: %d, Error: %s", retries, this.chunk.getChunkIndex(), e.getMessage()));
                            this.chunk.setStatus(ChunkStatus.DOWNLOAD_RETRY);
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                throw new DatabricksSQLException("Chunk download was interrupted", (Throwable)ie, DatabricksDriverErrorCode.THREAD_INTERRUPTED_ERROR);
                            }
                        }
                    }
                    if (!downloadSuccessful) break block13;
                    this.chunk.getChunkReadyFuture().complete(null);
                }
                catch (Throwable t2) {
                    try {
                        this.uncaughtException = t2;
                        throw t2;
                    }
                    catch (Throwable throwable) {
                        if (downloadSuccessful) {
                            this.chunk.getChunkReadyFuture().complete(null);
                        } else {
                            LOGGER.info("Uncaught exception during chunk download. Chunk index: %d, Error: %s", this.chunk.getChunkIndex(), Arrays.toString(this.uncaughtException.getStackTrace()));
                            this.chunk.setStatus(ChunkStatus.DOWNLOAD_FAILED);
                            this.chunk.getChunkReadyFuture().completeExceptionally(new DatabricksSQLException("Download failed for chunk index " + this.chunk.getChunkIndex(), DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR));
                        }
                        DatabricksThreadContextHolder.clearAllContext();
                        throw throwable;
                    }
                }
                break block14;
            }
            LOGGER.info("Uncaught exception during chunk download. Chunk index: %d, Error: %s", this.chunk.getChunkIndex(), Arrays.toString(this.uncaughtException.getStackTrace()));
            this.chunk.setStatus(ChunkStatus.DOWNLOAD_FAILED);
            this.chunk.getChunkReadyFuture().completeExceptionally(new DatabricksSQLException("Download failed for chunk index " + this.chunk.getChunkIndex(), DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR));
        }
        DatabricksThreadContextHolder.clearAllContext();
        return null;
    }
}

