/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.triangulate.quadedge;

import com.databricks.internal.jts.algorithm.PointLocation;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.triangulate.quadedge.QuadEdge;
import com.databricks.internal.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.databricks.internal.jts.triangulate.quadedge.TriangleVisitor;
import com.databricks.internal.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QuadEdgeTriangle {
    private QuadEdge[] edge;
    private Object data;

    public static List createOn(QuadEdgeSubdivision subdiv) {
        QuadEdgeTriangleBuilderVisitor visitor = new QuadEdgeTriangleBuilderVisitor();
        subdiv.visitTriangles(visitor, false);
        return visitor.getTriangles();
    }

    public static boolean contains(Vertex[] tri, Coordinate pt) {
        Coordinate[] ring = new Coordinate[]{tri[0].getCoordinate(), tri[1].getCoordinate(), tri[2].getCoordinate(), tri[0].getCoordinate()};
        return PointLocation.isInRing(pt, ring);
    }

    public static boolean contains(QuadEdge[] tri, Coordinate pt) {
        Coordinate[] ring = new Coordinate[]{tri[0].orig().getCoordinate(), tri[1].orig().getCoordinate(), tri[2].orig().getCoordinate(), tri[0].orig().getCoordinate()};
        return PointLocation.isInRing(pt, ring);
    }

    public static Geometry toPolygon(Vertex[] v) {
        Coordinate[] ringPts = new Coordinate[]{v[0].getCoordinate(), v[1].getCoordinate(), v[2].getCoordinate(), v[0].getCoordinate()};
        GeometryFactory fact = new GeometryFactory();
        LinearRing ring = fact.createLinearRing(ringPts);
        Polygon tri = fact.createPolygon(ring);
        return tri;
    }

    public static Geometry toPolygon(QuadEdge[] e) {
        Coordinate[] ringPts = new Coordinate[]{e[0].orig().getCoordinate(), e[1].orig().getCoordinate(), e[2].orig().getCoordinate(), e[0].orig().getCoordinate()};
        GeometryFactory fact = new GeometryFactory();
        LinearRing ring = fact.createLinearRing(ringPts);
        Polygon tri = fact.createPolygon(ring);
        return tri;
    }

    public static int nextIndex(int index) {
        index = (index + 1) % 3;
        return index;
    }

    public QuadEdgeTriangle(QuadEdge[] edge) {
        this.edge = Arrays.copyOf(edge, edge.length);
        for (int i = 0; i < 3; ++i) {
            edge[i].setData(this);
        }
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void kill() {
        this.edge = null;
    }

    public boolean isLive() {
        return this.edge != null;
    }

    public QuadEdge[] getEdges() {
        return this.edge;
    }

    public QuadEdge getEdge(int i) {
        return this.edge[i];
    }

    public Vertex getVertex(int i) {
        return this.edge[i].orig();
    }

    public Vertex[] getVertices() {
        Vertex[] vert = new Vertex[3];
        for (int i = 0; i < 3; ++i) {
            vert[i] = this.getVertex(i);
        }
        return vert;
    }

    public Coordinate getCoordinate(int i) {
        return this.edge[i].orig().getCoordinate();
    }

    public int getEdgeIndex(QuadEdge e) {
        for (int i = 0; i < 3; ++i) {
            if (this.edge[i] != e) continue;
            return i;
        }
        return -1;
    }

    public int getEdgeIndex(Vertex v) {
        for (int i = 0; i < 3; ++i) {
            if (this.edge[i].orig() != v) continue;
            return i;
        }
        return -1;
    }

    public void getEdgeSegment(int i, LineSegment seg) {
        seg.p0 = this.edge[i].orig().getCoordinate();
        int nexti = (i + 1) % 3;
        seg.p1 = this.edge[nexti].orig().getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] pts = new Coordinate[4];
        for (int i = 0; i < 3; ++i) {
            pts[i] = this.edge[i].orig().getCoordinate();
        }
        pts[3] = new Coordinate(pts[0]);
        return pts;
    }

    public boolean contains(Coordinate pt) {
        Coordinate[] ring = this.getCoordinates();
        return PointLocation.isInRing(pt, ring);
    }

    public Polygon getGeometry(GeometryFactory fact) {
        LinearRing ring = fact.createLinearRing(this.getCoordinates());
        Polygon tri = fact.createPolygon(ring);
        return tri;
    }

    public String toString() {
        return this.getGeometry(new GeometryFactory()).toString();
    }

    public boolean isBorder() {
        for (int i = 0; i < 3; ++i) {
            if (this.getAdjacentTriangleAcrossEdge(i) != null) continue;
            return true;
        }
        return false;
    }

    public boolean isBorder(int i) {
        return this.getAdjacentTriangleAcrossEdge(i) == null;
    }

    public QuadEdgeTriangle getAdjacentTriangleAcrossEdge(int edgeIndex) {
        return (QuadEdgeTriangle)this.getEdge(edgeIndex).sym().getData();
    }

    public int getAdjacentTriangleEdgeIndex(int i) {
        return this.getAdjacentTriangleAcrossEdge(i).getEdgeIndex(this.getEdge(i).sym());
    }

    public List getTrianglesAdjacentToVertex(int vertexIndex) {
        QuadEdge start;
        ArrayList<QuadEdgeTriangle> adjTris = new ArrayList<QuadEdgeTriangle>();
        QuadEdge qe = start = this.getEdge(vertexIndex);
        do {
            QuadEdgeTriangle adjTri;
            if ((adjTri = (QuadEdgeTriangle)qe.getData()) == null) continue;
            adjTris.add(adjTri);
        } while ((qe = qe.oNext()) != start);
        return adjTris;
    }

    public QuadEdgeTriangle[] getNeighbours() {
        QuadEdgeTriangle[] neigh = new QuadEdgeTriangle[3];
        for (int i = 0; i < 3; ++i) {
            neigh[i] = (QuadEdgeTriangle)this.getEdge(i).sym().getData();
        }
        return neigh;
    }

    private static class QuadEdgeTriangleBuilderVisitor
    implements TriangleVisitor {
        private List triangles = new ArrayList();

        @Override
        public void visit(QuadEdge[] edges) {
            this.triangles.add(new QuadEdgeTriangle(edges));
        }

        public List getTriangles() {
            return this.triangles;
        }
    }
}

