/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.distance3d;

import com.databricks.internal.jts.algorithm.RayCrossingCounter;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.math.Plane3D;
import com.databricks.internal.jts.math.Vector3D;
import com.databricks.internal.jts.operation.distance3d.AxisPlaneCoordinateSequence;

public class PlanarPolygon3D {
    private Plane3D plane;
    private Polygon poly;
    private int facingPlane = -1;

    public PlanarPolygon3D(Polygon poly) {
        this.poly = poly;
        this.plane = this.findBestFitPlane(poly);
        this.facingPlane = this.plane.closestAxisPlane();
    }

    private Plane3D findBestFitPlane(Polygon poly) {
        CoordinateSequence seq = poly.getExteriorRing().getCoordinateSequence();
        Coordinate basePt = this.averagePoint(seq);
        Vector3D normal = this.averageNormal(seq);
        return new Plane3D(normal, basePt);
    }

    private Vector3D averageNormal(CoordinateSequence seq) {
        int n = seq.size();
        Coordinate sum = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p2 = new Coordinate(0.0, 0.0, 0.0);
        for (int i = 0; i < n - 1; ++i) {
            seq.getCoordinate(i, p1);
            seq.getCoordinate(i + 1, p2);
            sum.x += (p1.y - p2.y) * (p1.getZ() + p2.getZ());
            sum.y += (p1.getZ() - p2.getZ()) * (p1.x + p2.x);
            sum.setZ(sum.getZ() + (p1.x - p2.x) * (p1.y + p2.y));
        }
        sum.x /= (double)n;
        sum.y /= (double)n;
        sum.setZ(sum.getZ() / (double)n);
        Vector3D norm = Vector3D.create(sum).normalize();
        return norm;
    }

    private Coordinate averagePoint(CoordinateSequence seq) {
        Coordinate a = new Coordinate(0.0, 0.0, 0.0);
        int n = seq.size();
        for (int i = 0; i < n; ++i) {
            a.x += seq.getOrdinate(i, 0);
            a.y += seq.getOrdinate(i, 1);
            a.setZ(a.getZ() + seq.getOrdinate(i, 2));
        }
        a.x /= (double)n;
        a.y /= (double)n;
        a.setZ(a.getZ() / (double)n);
        return a;
    }

    public Plane3D getPlane() {
        return this.plane;
    }

    public Polygon getPolygon() {
        return this.poly;
    }

    public boolean intersects(Coordinate intPt) {
        if (2 == this.locate(intPt, this.poly.getExteriorRing())) {
            return false;
        }
        for (int i = 0; i < this.poly.getNumInteriorRing(); ++i) {
            if (0 != this.locate(intPt, this.poly.getInteriorRingN(i))) continue;
            return false;
        }
        return true;
    }

    private int locate(Coordinate pt, LineString ring) {
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.project(pt, this.facingPlane);
        return RayCrossingCounter.locatePointInRing(ptProj, seqProj);
    }

    public boolean intersects(Coordinate pt, LineString ring) {
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.project(pt, this.facingPlane);
        return 2 != RayCrossingCounter.locatePointInRing(ptProj, seqProj);
    }

    private static CoordinateSequence project(CoordinateSequence seq, int facingPlane) {
        switch (facingPlane) {
            case 1: {
                return AxisPlaneCoordinateSequence.projectToXY(seq);
            }
            case 3: {
                return AxisPlaneCoordinateSequence.projectToXZ(seq);
            }
        }
        return AxisPlaneCoordinateSequence.projectToYZ(seq);
    }

    private static Coordinate project(Coordinate p, int facingPlane) {
        switch (facingPlane) {
            case 1: {
                return new Coordinate(p.x, p.y);
            }
            case 3: {
                return new Coordinate(p.x, p.getZ());
            }
        }
        return new Coordinate(p.y, p.getZ());
    }
}

