/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.cleanrooms;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAsset;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetAssetType;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetsImpl;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetsService;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAssetRequest;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAssetReviewRequest;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAssetReviewResponse;
import com.databricks.internal.sdk.service.cleanrooms.DeleteCleanRoomAssetRequest;
import com.databricks.internal.sdk.service.cleanrooms.GetCleanRoomAssetRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAssetsRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAssetsResponse;
import com.databricks.internal.sdk.service.cleanrooms.UpdateCleanRoomAssetRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CleanRoomAssetsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRoomAssetsAPI.class);
    private final CleanRoomAssetsService impl;

    public CleanRoomAssetsAPI(ApiClient apiClient) {
        this.impl = new CleanRoomAssetsImpl(apiClient);
    }

    public CleanRoomAssetsAPI(CleanRoomAssetsService mock) {
        this.impl = mock;
    }

    public CleanRoomAsset create(CreateCleanRoomAssetRequest request) {
        return this.impl.create(request);
    }

    public CreateCleanRoomAssetReviewResponse createCleanRoomAssetReview(CreateCleanRoomAssetReviewRequest request) {
        return this.impl.createCleanRoomAssetReview(request);
    }

    public void delete(String cleanRoomName, CleanRoomAssetAssetType assetType, String name) {
        this.delete(new DeleteCleanRoomAssetRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setName(name));
    }

    public void delete(DeleteCleanRoomAssetRequest request) {
        this.impl.delete(request);
    }

    public CleanRoomAsset get(String cleanRoomName, CleanRoomAssetAssetType assetType, String name) {
        return this.get(new GetCleanRoomAssetRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setName(name));
    }

    public CleanRoomAsset get(GetCleanRoomAssetRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CleanRoomAsset> list(String cleanRoomName) {
        return this.list(new ListCleanRoomAssetsRequest().setCleanRoomName(cleanRoomName));
    }

    public Iterable<CleanRoomAsset> list(ListCleanRoomAssetsRequest request) {
        return new Paginator(request, this.impl::list, ListCleanRoomAssetsResponse::getAssets, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CleanRoomAsset update(UpdateCleanRoomAssetRequest request) {
        return this.impl.update(request);
    }

    public CleanRoomAssetsService impl() {
        return this.impl;
    }
}

