/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.sdk.service.sql.StatementState;
import com.databricks.jdbc.api.ExecutionState;
import com.databricks.jdbc.api.IExecutionStatus;
import com.databricks.jdbc.model.core.StatementStatus;

class ExecutionStatus
implements IExecutionStatus {
    private final ExecutionState state;
    private final String errorMessage;
    private final String sqlState;
    private final StatementStatus sdkStatus;

    public ExecutionStatus(StatementStatus status) {
        this.state = this.getStateFromSdkState(status.getState());
        this.errorMessage = status.getError() != null ? status.getError().getMessage() : null;
        this.sqlState = status.getSqlState();
        this.sdkStatus = status;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getSqlState() {
        return this.sqlState;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.state;
    }

    StatementStatus getSdkStatus() {
        return this.sdkStatus;
    }

    private ExecutionState getStateFromSdkState(StatementState state) {
        if (state == null) {
            return ExecutionState.PENDING;
        }
        switch (state) {
            case PENDING: {
                return ExecutionState.PENDING;
            }
            case RUNNING: {
                return ExecutionState.RUNNING;
            }
            case SUCCEEDED: {
                return ExecutionState.SUCCEEDED;
            }
            case FAILED: {
                return ExecutionState.FAILED;
            }
            case CANCELED: {
                return ExecutionState.ABORTED;
            }
            case CLOSED: {
                return ExecutionState.CLOSED;
            }
        }
        throw new IllegalArgumentException("Unknown statement execution state: " + String.valueOf((Object)state));
    }
}

