/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sql.DeleteQueriesLegacyRequest;
import com.databricks.internal.sdk.service.sql.GetQueriesLegacyRequest;
import com.databricks.internal.sdk.service.sql.LegacyQuery;
import com.databricks.internal.sdk.service.sql.ListQueriesLegacyRequest;
import com.databricks.internal.sdk.service.sql.QueriesLegacyService;
import com.databricks.internal.sdk.service.sql.QueryEditContent;
import com.databricks.internal.sdk.service.sql.QueryList;
import com.databricks.internal.sdk.service.sql.QueryPostContent;
import com.databricks.internal.sdk.service.sql.RestoreQueriesLegacyRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class QueriesLegacyImpl
implements QueriesLegacyService {
    private final ApiClient apiClient;

    public QueriesLegacyImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public LegacyQuery create(QueryPostContent request) {
        String path = "/api/2.0/preview/sql/queries";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, LegacyQuery.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteQueriesLegacyRequest request) {
        String path = String.format("/api/2.0/preview/sql/queries/%s", request.getQueryId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public LegacyQuery get(GetQueriesLegacyRequest request) {
        String path = String.format("/api/2.0/preview/sql/queries/%s", request.getQueryId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, LegacyQuery.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public QueryList list(ListQueriesLegacyRequest request) {
        String path = "/api/2.0/preview/sql/queries";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, QueryList.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void restore(RestoreQueriesLegacyRequest request) {
        String path = String.format("/api/2.0/preview/sql/queries/trash/%s", request.getQueryId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public LegacyQuery update(QueryEditContent request) {
        String path = String.format("/api/2.0/preview/sql/queries/%s", request.getQueryId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, LegacyQuery.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

