/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.sql.Dashboard;
import com.databricks.internal.sdk.service.sql.DashboardEditContent;
import com.databricks.internal.sdk.service.sql.DashboardsImpl;
import com.databricks.internal.sdk.service.sql.DashboardsService;
import com.databricks.internal.sdk.service.sql.DeleteDashboardRequest;
import com.databricks.internal.sdk.service.sql.GetDashboardRequest;
import com.databricks.internal.sdk.service.sql.ListDashboardsRequest;
import com.databricks.internal.sdk.service.sql.ListResponse;
import com.databricks.internal.sdk.service.sql.RestoreDashboardRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class DashboardsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardsAPI.class);
    private final DashboardsService impl;

    public DashboardsAPI(ApiClient apiClient) {
        this.impl = new DashboardsImpl(apiClient);
    }

    public DashboardsAPI(DashboardsService mock) {
        this.impl = mock;
    }

    public void delete(String dashboardId) {
        this.delete(new DeleteDashboardRequest().setDashboardId(dashboardId));
    }

    public void delete(DeleteDashboardRequest request) {
        this.impl.delete(request);
    }

    public Dashboard get(String dashboardId) {
        return this.get(new GetDashboardRequest().setDashboardId(dashboardId));
    }

    public Dashboard get(GetDashboardRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Dashboard> list(ListDashboardsRequest request) {
        request.setPage(1L);
        return new Paginator(request, this.impl::list, ListResponse::getResults, response -> {
            Long page = request.getPage();
            if (page == null) {
                page = 1L;
            }
            return request.setPage(page + 1L);
        });
    }

    public void restore(RestoreDashboardRequest request) {
        this.impl.restore(request);
    }

    public Dashboard update(DashboardEditContent request) {
        return this.impl.update(request);
    }

    public DashboardsService impl() {
        return this.impl;
    }
}

