/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sharing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.sharing.ListSharesRequest;
import com.databricks.internal.sdk.service.sharing.ListSharesResponse;
import com.databricks.internal.sdk.service.sharing.ShareInfo;
import com.databricks.internal.sdk.service.sharing.SharesImpl;
import com.databricks.internal.sdk.service.sharing.SharesService;
import com.databricks.internal.sdk.support.Paginator;

class SharesExtAPI {
    final SharesService impl;

    public SharesExtAPI(ApiClient apiClient) {
        this.impl = new SharesImpl(apiClient);
    }

    public SharesExtAPI(SharesService mock) {
        this.impl = mock;
    }

    public Iterable<ShareInfo> list(String name) {
        return this.list(new ListSharesRequest().setName(name));
    }

    public Iterable<ShareInfo> list(ListSharesRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::list, ListSharesResponse::getShares, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }
}

