/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sharing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sharing.CreateFederationPolicyRequest;
import com.databricks.internal.sdk.service.sharing.DeleteFederationPolicyRequest;
import com.databricks.internal.sdk.service.sharing.FederationPolicy;
import com.databricks.internal.sdk.service.sharing.GetFederationPolicyRequest;
import com.databricks.internal.sdk.service.sharing.ListFederationPoliciesRequest;
import com.databricks.internal.sdk.service.sharing.ListFederationPoliciesResponse;
import com.databricks.internal.sdk.service.sharing.RecipientFederationPoliciesService;
import com.databricks.internal.sdk.service.sharing.UpdateFederationPolicyRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class RecipientFederationPoliciesImpl
implements RecipientFederationPoliciesService {
    private final ApiClient apiClient;

    public RecipientFederationPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public FederationPolicy create(CreateFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies", request.getRecipientName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, FederationPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies/%s", request.getRecipientName(), request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public FederationPolicy getFederationPolicy(GetFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies/%s", request.getRecipientName(), request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, FederationPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListFederationPoliciesResponse list(ListFederationPoliciesRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies", request.getRecipientName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListFederationPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public FederationPolicy update(UpdateFederationPolicyRequest request) {
        String path = String.format("/api/2.0/data-sharing/recipients/%s/federation-policies/%s", request.getRecipientName(), request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, FederationPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

