/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.ml;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.ml.CreateFeatureRequest;
import com.databricks.internal.sdk.service.ml.DeleteFeatureRequest;
import com.databricks.internal.sdk.service.ml.Feature;
import com.databricks.internal.sdk.service.ml.FeatureEngineeringImpl;
import com.databricks.internal.sdk.service.ml.FeatureEngineeringService;
import com.databricks.internal.sdk.service.ml.GetFeatureRequest;
import com.databricks.internal.sdk.service.ml.ListFeaturesRequest;
import com.databricks.internal.sdk.service.ml.ListFeaturesResponse;
import com.databricks.internal.sdk.service.ml.UpdateFeatureRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FeatureEngineeringAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureEngineeringAPI.class);
    private final FeatureEngineeringService impl;

    public FeatureEngineeringAPI(ApiClient apiClient) {
        this.impl = new FeatureEngineeringImpl(apiClient);
    }

    public FeatureEngineeringAPI(FeatureEngineeringService mock) {
        this.impl = mock;
    }

    public Feature createFeature(CreateFeatureRequest request) {
        return this.impl.createFeature(request);
    }

    public void deleteFeature(String fullName) {
        this.deleteFeature(new DeleteFeatureRequest().setFullName(fullName));
    }

    public void deleteFeature(DeleteFeatureRequest request) {
        this.impl.deleteFeature(request);
    }

    public Feature getFeature(String fullName) {
        return this.getFeature(new GetFeatureRequest().setFullName(fullName));
    }

    public Feature getFeature(GetFeatureRequest request) {
        return this.impl.getFeature(request);
    }

    public Iterable<Feature> listFeatures(ListFeaturesRequest request) {
        return new Paginator(request, this.impl::listFeatures, ListFeaturesResponse::getFeatures, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Feature updateFeature(UpdateFeatureRequest request) {
        return this.impl.updateFeature(request);
    }

    public FeatureEngineeringService impl() {
        return this.impl;
    }
}

