/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CreateMetastore;
import com.databricks.internal.sdk.service.catalog.CreateMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.DeleteMetastoreRequest;
import com.databricks.internal.sdk.service.catalog.GetMetastoreRequest;
import com.databricks.internal.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.databricks.internal.sdk.service.catalog.ListMetastoresRequest;
import com.databricks.internal.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.internal.sdk.service.catalog.MetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.MetastoreInfo;
import com.databricks.internal.sdk.service.catalog.MetastoresImpl;
import com.databricks.internal.sdk.service.catalog.MetastoresService;
import com.databricks.internal.sdk.service.catalog.UnassignRequest;
import com.databricks.internal.sdk.service.catalog.UpdateMetastore;
import com.databricks.internal.sdk.service.catalog.UpdateMetastoreAssignment;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class MetastoresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoresAPI.class);
    private final MetastoresService impl;

    public MetastoresAPI(ApiClient apiClient) {
        this.impl = new MetastoresImpl(apiClient);
    }

    public MetastoresAPI(MetastoresService mock) {
        this.impl = mock;
    }

    public void assign(CreateMetastoreAssignment request) {
        this.impl.assign(request);
    }

    public MetastoreInfo create(CreateMetastore request) {
        return this.impl.create(request);
    }

    public MetastoreAssignment current() {
        return this.impl.current();
    }

    public void delete(String id) {
        this.delete(new DeleteMetastoreRequest().setId(id));
    }

    public void delete(DeleteMetastoreRequest request) {
        this.impl.delete(request);
    }

    public MetastoreInfo get(String id) {
        return this.get(new GetMetastoreRequest().setId(id));
    }

    public MetastoreInfo get(GetMetastoreRequest request) {
        return this.impl.get(request);
    }

    public Iterable<MetastoreInfo> list(ListMetastoresRequest request) {
        return new Paginator(request, this.impl::list, ListMetastoresResponse::getMetastores, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public GetMetastoreSummaryResponse summary() {
        return this.impl.summary();
    }

    public void unassign(long workspaceId) {
        this.unassign(new UnassignRequest().setWorkspaceId(workspaceId));
    }

    public void unassign(UnassignRequest request) {
        this.impl.unassign(request);
    }

    public MetastoreInfo update(UpdateMetastore request) {
        return this.impl.update(request);
    }

    public void updateAssignment(UpdateMetastoreAssignment request) {
        this.impl.updateAssignment(request);
    }

    public MetastoresService impl() {
        return this.impl;
    }
}

