/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.billing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.billing.BudgetConfiguration;
import com.databricks.internal.sdk.service.billing.BudgetsImpl;
import com.databricks.internal.sdk.service.billing.BudgetsService;
import com.databricks.internal.sdk.service.billing.CreateBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.CreateBudgetConfigurationResponse;
import com.databricks.internal.sdk.service.billing.DeleteBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.GetBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.GetBudgetConfigurationResponse;
import com.databricks.internal.sdk.service.billing.ListBudgetConfigurationsRequest;
import com.databricks.internal.sdk.service.billing.ListBudgetConfigurationsResponse;
import com.databricks.internal.sdk.service.billing.UpdateBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.UpdateBudgetConfigurationResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class BudgetsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(BudgetsAPI.class);
    private final BudgetsService impl;

    public BudgetsAPI(ApiClient apiClient) {
        this.impl = new BudgetsImpl(apiClient);
    }

    public BudgetsAPI(BudgetsService mock) {
        this.impl = mock;
    }

    public CreateBudgetConfigurationResponse create(CreateBudgetConfigurationRequest request) {
        return this.impl.create(request);
    }

    public void delete(String budgetId) {
        this.delete(new DeleteBudgetConfigurationRequest().setBudgetId(budgetId));
    }

    public void delete(DeleteBudgetConfigurationRequest request) {
        this.impl.delete(request);
    }

    public GetBudgetConfigurationResponse get(String budgetId) {
        return this.get(new GetBudgetConfigurationRequest().setBudgetId(budgetId));
    }

    public GetBudgetConfigurationResponse get(GetBudgetConfigurationRequest request) {
        return this.impl.get(request);
    }

    public Iterable<BudgetConfiguration> list(ListBudgetConfigurationsRequest request) {
        return new Paginator(request, this.impl::list, ListBudgetConfigurationsResponse::getBudgets, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateBudgetConfigurationResponse update(UpdateBudgetConfigurationRequest request) {
        return this.impl.update(request);
    }

    public BudgetsService impl() {
        return this.impl;
    }
}

