/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.fasterxml.jackson.databind.node.ObjectNode;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.core.http.Response;
import java.io.IOException;

public class GitHubOidcTokenSupplier {
    private final ObjectMapper mapper = new ObjectMapper();
    private final HttpClient httpClient;
    private final String idTokenRequestUrl;
    private final String idTokenRequestToken;
    private final String tokenAudience;

    public GitHubOidcTokenSupplier(HttpClient httpClient, String idTokenRequestUrl, String idTokenRequestToken, String tokenAudience) {
        this.httpClient = httpClient;
        this.idTokenRequestUrl = idTokenRequestUrl;
        this.idTokenRequestToken = idTokenRequestToken;
        this.tokenAudience = tokenAudience;
    }

    public Boolean enabled() {
        return this.idTokenRequestUrl != null && this.idTokenRequestToken != null;
    }

    public String getOidcToken() {
        ObjectNode jsonResp;
        Response resp;
        if (!this.enabled().booleanValue()) {
            throw new DatabricksException("Failed to request ID token: missing required parameters");
        }
        String requestUrl = this.idTokenRequestUrl;
        if (this.tokenAudience != null) {
            requestUrl = requestUrl + "&audience=" + this.tokenAudience;
        }
        Request req = new Request("GET", requestUrl).withHeader("Authorization", "Bearer " + this.idTokenRequestToken);
        try {
            resp = this.httpClient.execute(req);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token from " + requestUrl + ":" + e.getMessage(), e);
        }
        if (resp.getStatusCode() != 200) {
            throw new DatabricksException("Failed to request ID token: status code " + resp.getStatusCode() + ", response body: " + resp.getBody().toString());
        }
        try {
            jsonResp = this.mapper.readValue(resp.getBody(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token: corrupted token: " + e.getMessage());
        }
        return jsonResp.get("value").textValue();
    }
}

