/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.http;

import com.databricks.internal.sdk.core.http.Request;
import java.util.function.Function;

public class RequestOptions {
    private Function<Request, Request> authenticateFunc = request -> request;
    private Function<Request, Request> urlFunc = request -> request;
    private Function<Request, Request> userAgentFunc = request -> request;

    public RequestOptions withAuthorization(String authorization) {
        this.authenticateFunc = request -> request.withHeader("Authorization", authorization);
        return this;
    }

    public RequestOptions withUrl(String url) {
        this.urlFunc = request -> request.withUrl(url);
        return this;
    }

    public RequestOptions withUserAgent(String userAgent) {
        this.userAgentFunc = request -> request.withHeader("User-Agent", userAgent);
        return this;
    }

    public Request applyOptions(Request request) {
        return this.userAgentFunc.apply(this.urlFunc.apply(this.authenticateFunc.apply(request)));
    }
}

