/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.nimbusds.jwt;

import com.databricks.internal.nimbusds.jose.Algorithm;
import com.databricks.internal.nimbusds.jose.Header;
import com.databricks.internal.nimbusds.jose.JWEAlgorithm;
import com.databricks.internal.nimbusds.jose.JWSAlgorithm;
import com.databricks.internal.nimbusds.jose.util.Base64URL;
import com.databricks.internal.nimbusds.jose.util.JSONObjectUtils;
import com.databricks.internal.nimbusds.jwt.EncryptedJWT;
import com.databricks.internal.nimbusds.jwt.JWT;
import com.databricks.internal.nimbusds.jwt.PlainJWT;
import com.databricks.internal.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Map;

public final class JWTParser {
    public static JWT parse(String s2) throws ParseException {
        Map<String, Object> jsonObject;
        int firstDotPos = s2.indexOf(".");
        if (firstDotPos == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL header = new Base64URL(s2.substring(0, firstDotPos));
        try {
            jsonObject = JSONObjectUtils.parse(header.decodeToString());
        }
        catch (ParseException e) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + e.getMessage(), 0);
        }
        Algorithm alg = Header.parseAlgorithm(jsonObject);
        if (alg.equals(Algorithm.NONE)) {
            return PlainJWT.parse(s2);
        }
        if (alg instanceof JWSAlgorithm) {
            return SignedJWT.parse(s2);
        }
        if (alg instanceof JWEAlgorithm) {
            return EncryptedJWT.parse(s2);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + alg));
    }

    private JWTParser() {
    }
}

