/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.mime.smime;

import com.databricks.internal.bouncycastle.mime.BasicMimeParser;
import com.databricks.internal.bouncycastle.mime.Headers;
import com.databricks.internal.bouncycastle.mime.MimeParser;
import com.databricks.internal.bouncycastle.mime.MimeParserProvider;
import com.databricks.internal.bouncycastle.mime.smime.SMimeParserContext;
import com.databricks.internal.bouncycastle.mime.smime.SMimeUtils;
import com.databricks.internal.bouncycastle.operator.DigestCalculatorProvider;
import java.io.IOException;
import java.io.InputStream;

public class SMimeParserProvider
implements MimeParserProvider {
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String string, DigestCalculatorProvider digestCalculatorProvider) {
        this.defaultContentTransferEncoding = string;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    @Override
    public MimeParser createParser(InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), SMimeUtils.autoBuffer(inputStream));
    }

    @Override
    public MimeParser createParser(Headers headers, InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), headers, SMimeUtils.autoBuffer(inputStream));
    }
}

