/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.dvcs;

import com.databricks.internal.bouncycastle.asn1.x509.DigestInfo;
import com.databricks.internal.bouncycastle.dvcs.DVCSException;
import com.databricks.internal.bouncycastle.dvcs.MessageImprint;
import com.databricks.internal.bouncycastle.operator.DigestCalculator;
import java.io.OutputStream;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] byArray) throws DVCSException {
        try {
            OutputStream outputStream = this.digestCalculator.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception exception) {
            throw new DVCSException("unable to build MessageImprint: " + exception.getMessage(), exception);
        }
    }
}

