/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cert.crmf;

import com.databricks.internal.bouncycastle.asn1.ASN1Integer;
import com.databricks.internal.bouncycastle.asn1.ASN1Object;
import com.databricks.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.databricks.internal.bouncycastle.asn1.ASN1UTF8String;
import com.databricks.internal.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import com.databricks.internal.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.databricks.internal.bouncycastle.asn1.crmf.CertReqMsg;
import com.databricks.internal.bouncycastle.asn1.crmf.CertTemplate;
import com.databricks.internal.bouncycastle.asn1.crmf.Controls;
import com.databricks.internal.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.databricks.internal.bouncycastle.asn1.crmf.PKMACValue;
import com.databricks.internal.bouncycastle.asn1.crmf.POPOSigningKey;
import com.databricks.internal.bouncycastle.asn1.crmf.ProofOfPossession;
import com.databricks.internal.bouncycastle.cert.CertIOException;
import com.databricks.internal.bouncycastle.cert.crmf.AuthenticatorControl;
import com.databricks.internal.bouncycastle.cert.crmf.CRMFException;
import com.databricks.internal.bouncycastle.cert.crmf.CRMFUtil;
import com.databricks.internal.bouncycastle.cert.crmf.Control;
import com.databricks.internal.bouncycastle.cert.crmf.PKIArchiveControl;
import com.databricks.internal.bouncycastle.cert.crmf.PKMACBuilder;
import com.databricks.internal.bouncycastle.cert.crmf.PKMACValueVerifier;
import com.databricks.internal.bouncycastle.cert.crmf.RegTokenControl;
import com.databricks.internal.bouncycastle.operator.ContentVerifier;
import com.databricks.internal.bouncycastle.operator.ContentVerifierProvider;
import com.databricks.internal.bouncycastle.operator.OperatorCreationException;
import com.databricks.internal.bouncycastle.util.Encodable;
import java.io.IOException;

public class CertificateRequestMessage
implements Encodable {
    public static final int popRaVerified = 0;
    public static final int popSigningKey = 1;
    public static final int popKeyEncipherment = 2;
    public static final int popKeyAgreement = 3;
    private final CertReqMsg certReqMsg;
    private final Controls controls;

    private static CertReqMsg parseBytes(byte[] byArray) throws IOException {
        try {
            return CertReqMsg.getInstance(byArray);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public CertificateRequestMessage(byte[] byArray) throws IOException {
        this(CertificateRequestMessage.parseBytes(byArray));
    }

    public CertificateRequestMessage(CertReqMsg certReqMsg) {
        this.certReqMsg = certReqMsg;
        this.controls = certReqMsg.getCertReq().getControls();
    }

    public CertReqMsg toASN1Structure() {
        return this.certReqMsg;
    }

    public ASN1Integer getCertReqId() {
        return this.certReqMsg.getCertReq().getCertReqId();
    }

    public CertTemplate getCertTemplate() {
        return this.certReqMsg.getCertReq().getCertTemplate();
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public boolean hasControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.findControl(aSN1ObjectIdentifier) != null;
    }

    public Control getControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AttributeTypeAndValue attributeTypeAndValue = this.findControl(aSN1ObjectIdentifier);
        if (attributeTypeAndValue != null) {
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions)) {
                return new PKIArchiveControl(PKIArchiveOptions.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_regToken)) {
                return new RegTokenControl(ASN1UTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals(CRMFObjectIdentifiers.id_regCtrl_authenticator)) {
                return new AuthenticatorControl(ASN1UTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
        }
        return null;
    }

    private AttributeTypeAndValue findControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.controls == null) {
            return null;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray = this.controls.toAttributeTypeAndValueArray();
        AttributeTypeAndValue attributeTypeAndValue = null;
        for (int i = 0; i != attributeTypeAndValueArray.length; ++i) {
            if (!attributeTypeAndValueArray[i].getType().equals(aSN1ObjectIdentifier)) continue;
            attributeTypeAndValue = attributeTypeAndValueArray[i];
            break;
        }
        return attributeTypeAndValue;
    }

    public boolean hasProofOfPossession() {
        return this.certReqMsg.getPop() != null;
    }

    public int getProofOfPossessionType() {
        return this.certReqMsg.getPop().getType();
    }

    public boolean hasSigningKeyProofOfPossessionWithPKMAC() {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPop();
        if (proofOfPossession.getType() != 1) {
            return false;
        }
        POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
        return pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null;
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider contentVerifierProvider) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPop();
        if (proofOfPossession.getType() != 1) {
            throw new IllegalStateException("not Signing Key type of proof of possession");
        }
        POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
        if (pOPOSigningKey.getPoposkInput() != null && pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null) {
            throw new IllegalStateException("verification requires password check");
        }
        return this.verifySignature(contentVerifierProvider, pOPOSigningKey);
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider contentVerifierProvider, PKMACBuilder pKMACBuilder, char[] cArray) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPop();
        if (proofOfPossession.getType() != 1) {
            throw new IllegalStateException("not Signing Key type of proof of possession");
        }
        POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance(proofOfPossession.getObject());
        if (pOPOSigningKey.getPoposkInput() == null || pOPOSigningKey.getPoposkInput().getSender() != null) {
            throw new IllegalStateException("no PKMAC present in proof of possession");
        }
        PKMACValueVerifier pKMACValueVerifier = new PKMACValueVerifier(pKMACBuilder);
        PKMACValue pKMACValue = pOPOSigningKey.getPoposkInput().getPublicKeyMAC();
        return pKMACValueVerifier.isValid(pKMACValue, cArray, this.getCertTemplate().getPublicKey()) && this.verifySignature(contentVerifierProvider, pOPOSigningKey);
    }

    private boolean verifySignature(ContentVerifierProvider contentVerifierProvider, POPOSigningKey pOPOSigningKey) throws CRMFException {
        ContentVerifier contentVerifier;
        try {
            contentVerifier = contentVerifierProvider.get(pOPOSigningKey.getAlgorithmIdentifier());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CRMFException("unable to create verifier: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        ASN1Object aSN1Object = pOPOSigningKey.getPoposkInput();
        if (aSN1Object == null) {
            aSN1Object = this.certReqMsg.getCertReq();
        }
        CRMFUtil.derEncodeToStream(aSN1Object, contentVerifier.getOutputStream());
        return contentVerifier.verify(pOPOSigningKey.getSignature().getOctets());
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certReqMsg.getEncoded();
    }
}

