/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.asn1.cmp;

import com.databricks.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.databricks.internal.bouncycastle.asn1.ASN1Object;
import com.databricks.internal.bouncycastle.asn1.ASN1Primitive;
import com.databricks.internal.bouncycastle.asn1.ASN1Sequence;
import com.databricks.internal.bouncycastle.asn1.DERSequence;
import com.databricks.internal.bouncycastle.asn1.cmp.CMPCertificate;

public class CAKeyUpdAnnContent
extends ASN1Object {
    private final CMPCertificate oldWithNew;
    private final CMPCertificate newWithOld;
    private final CMPCertificate newWithNew;

    private CAKeyUpdAnnContent(ASN1Sequence aSN1Sequence) {
        this.oldWithNew = CMPCertificate.getInstance(aSN1Sequence.getObjectAt(0));
        this.newWithOld = CMPCertificate.getInstance(aSN1Sequence.getObjectAt(1));
        this.newWithNew = CMPCertificate.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public CAKeyUpdAnnContent(CMPCertificate cMPCertificate, CMPCertificate cMPCertificate2, CMPCertificate cMPCertificate3) {
        this.oldWithNew = cMPCertificate;
        this.newWithOld = cMPCertificate2;
        this.newWithNew = cMPCertificate3;
    }

    public static CAKeyUpdAnnContent getInstance(Object object) {
        if (object instanceof CAKeyUpdAnnContent) {
            return (CAKeyUpdAnnContent)object;
        }
        if (object != null) {
            return new CAKeyUpdAnnContent(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CMPCertificate getOldWithNew() {
        return this.oldWithNew;
    }

    public CMPCertificate getNewWithOld() {
        return this.newWithOld;
    }

    public CMPCertificate getNewWithNew() {
        return this.newWithNew;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.oldWithNew);
        aSN1EncodableVector.add(this.newWithOld);
        aSN1EncodableVector.add(this.newWithNew);
        return new DERSequence(aSN1EncodableVector);
    }
}

