/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.commons.configuration2.tree;

import com.databricks.internal.apache.commons.lang3.builder.EqualsBuilder;
import com.databricks.internal.apache.commons.lang3.builder.HashCodeBuilder;
import com.databricks.internal.apache.commons.lang3.builder.ToStringBuilder;

public final class DefaultExpressionEngineSymbols {
    public static final String DEFAULT_PROPERTY_DELIMITER = ".";
    public static final String DEFAULT_ESCAPED_DELIMITER = "..";
    public static final String DEFAULT_ATTRIBUTE_START = "[@";
    public static final String DEFAULT_ATTRIBUTE_END = "]";
    public static final String DEFAULT_INDEX_START = "(";
    public static final String DEFAULT_INDEX_END = ")";
    public static final DefaultExpressionEngineSymbols DEFAULT_SYMBOLS = DefaultExpressionEngineSymbols.createDefaultSmybols();
    private final String propertyDelimiter;
    private final String escapedDelimiter;
    private final String attributeStart;
    private final String attributeEnd;
    private final String indexStart;
    private final String indexEnd;

    private DefaultExpressionEngineSymbols(Builder b) {
        this.propertyDelimiter = b.propertyDelimiter;
        this.escapedDelimiter = b.escapedDelimiter;
        this.indexStart = b.indexStart;
        this.indexEnd = b.indexEnd;
        this.attributeStart = b.attributeStart;
        this.attributeEnd = b.attributeEnd;
    }

    public String getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    public String getEscapedDelimiter() {
        return this.escapedDelimiter;
    }

    public String getAttributeStart() {
        return this.attributeStart;
    }

    public String getAttributeEnd() {
        return this.attributeEnd;
    }

    public String getIndexStart() {
        return this.indexStart;
    }

    public String getIndexEnd() {
        return this.indexEnd;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getPropertyDelimiter()).append(this.getEscapedDelimiter()).append(this.getIndexStart()).append(this.getIndexEnd()).append(this.getAttributeStart()).append(this.getAttributeEnd()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultExpressionEngineSymbols)) {
            return false;
        }
        DefaultExpressionEngineSymbols c = (DefaultExpressionEngineSymbols)obj;
        return new EqualsBuilder().append(this.getPropertyDelimiter(), c.getPropertyDelimiter()).append(this.getEscapedDelimiter(), c.getEscapedDelimiter()).append(this.getIndexStart(), c.getIndexStart()).append(this.getIndexEnd(), c.getIndexEnd()).append(this.getAttributeStart(), c.getAttributeStart()).append(this.getAttributeEnd(), c.getAttributeEnd()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this).append("propertyDelimiter", this.getPropertyDelimiter()).append("escapedDelimiter", this.getEscapedDelimiter()).append("indexStart", this.getIndexStart()).append("indexEnd", this.getIndexEnd()).append("attributeStart", this.getAttributeStart()).append("attributeEnd", this.getAttributeEnd()).toString();
    }

    private static DefaultExpressionEngineSymbols createDefaultSmybols() {
        return new Builder().setPropertyDelimiter(DEFAULT_PROPERTY_DELIMITER).setEscapedDelimiter(DEFAULT_ESCAPED_DELIMITER).setIndexStart(DEFAULT_INDEX_START).setIndexEnd(DEFAULT_INDEX_END).setAttributeStart(DEFAULT_ATTRIBUTE_START).setAttributeEnd(DEFAULT_ATTRIBUTE_END).create();
    }

    public static class Builder {
        private String propertyDelimiter;
        private String escapedDelimiter;
        private String attributeStart;
        private String attributeEnd;
        private String indexStart;
        private String indexEnd;

        public Builder() {
        }

        public Builder(DefaultExpressionEngineSymbols c) {
            this.propertyDelimiter = c.getPropertyDelimiter();
            this.escapedDelimiter = c.getEscapedDelimiter();
            this.indexStart = c.getIndexStart();
            this.indexEnd = c.getIndexEnd();
            this.attributeStart = c.getAttributeStart();
            this.attributeEnd = c.getAttributeEnd();
        }

        public Builder setPropertyDelimiter(String propertyDelimiter) {
            this.propertyDelimiter = propertyDelimiter;
            return this;
        }

        public Builder setEscapedDelimiter(String escapedDelimiter) {
            this.escapedDelimiter = escapedDelimiter;
            return this;
        }

        public Builder setIndexStart(String is) {
            this.indexStart = is;
            return this;
        }

        public Builder setIndexEnd(String indexEnd) {
            this.indexEnd = indexEnd;
            return this;
        }

        public Builder setAttributeStart(String attributeStart) {
            this.attributeStart = attributeStart;
            return this;
        }

        public Builder setAttributeEnd(String attributeEnd) {
            this.attributeEnd = attributeEnd;
            return this;
        }

        public DefaultExpressionEngineSymbols create() {
            return new DefaultExpressionEngineSymbols(this);
        }
    }
}

