/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.streams.resultsetinput;

import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.streams.TruncatedReader;
import com.databricks.client.streams.resultsetinput.AbstractDataStream;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ExceptionType;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class CharacterDataStream
extends AbstractDataStream {
    private Reader m_reader = null;

    public CharacterDataStream(Reader reader, long l, int n, IWarningListener iWarningListener) {
        super(null, l, n, iWarningListener);
        this.m_reader = reader;
    }

    @Override
    public void close() {
        super.close();
        if (!this.isClosed()) {
            try {
                this.m_reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_reader = null;
        }
    }

    @Override
    public Pair<DataWrapper, Long> getNextValue() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        if (!this.hasMoreData()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_EMPTY, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        int n = this.getNumToFetch();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        while (-1L == this.m_streamLength && -1 != n3 || -1L != this.m_streamLength && n2 + this.m_numRead < n) {
            try {
                n3 = this.m_reader.read();
            }
            catch (IOException iOException) {
                throw ExceptionConverter.getInstance().toSQLException(iOException, this.m_warningListener);
            }
            if ((-1L != this.m_streamLength || -1 == n3) && -1L == this.m_streamLength) continue;
            stringBuffer.append((char)n3);
            ++n2;
        }
        if (-1 == n3) {
            if (-1L != this.m_streamLength) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_UNEXPECTED_END, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_lastChunkReadSize = -1L;
        } else {
            this.m_lastChunkReadSize = n2;
        }
        this.m_numRead += n2;
        DataWrapper dataWrapper = new DataWrapper();
        try {
            if (12 == this.m_type) {
                dataWrapper.setVarChar(stringBuffer.toString());
            } else {
                dataWrapper.setLongVarChar(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CORRUPT_UTF, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        return new Pair<DataWrapper, Long>(dataWrapper, (long)n2 * 2L);
    }

    @Override
    protected boolean isClosed() {
        return null == this.m_reader;
    }

    @Override
    public boolean canGetAsReader() {
        return true;
    }

    @Override
    public Reader getAsReader() {
        if (this.isClosed()) {
            throw new RuntimeException("Already closed!");
        }
        Reader reader = this.m_streamLength >= 0L ? new TruncatedReader(this.m_reader, this.m_streamLength) : this.m_reader;
        this.m_reader = null;
        this.close();
        return reader;
    }
}

