/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.utilities;

import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.IPTVisitor;
import com.databricks.client.sqlengine.parser.parsetree.PTDefaultParameterNode;
import com.databricks.client.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.databricks.client.sqlengine.parser.parsetree.PTEmptyNode;
import com.databricks.client.sqlengine.parser.parsetree.PTFlagNode;
import com.databricks.client.sqlengine.parser.parsetree.PTIdentifierNode;
import com.databricks.client.sqlengine.parser.parsetree.PTListNode;
import com.databricks.client.sqlengine.parser.parsetree.PTLiteralNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Stack;

public class PTToStringConverter {
    private static final String INDENT_STR = "    ";
    private String m_lineInitials;
    private TreeVisitor m_visitor;

    public PTToStringConverter() {
        this.m_lineInitials = "";
        this.m_visitor = new TreeVisitor();
    }

    public PTToStringConverter(String string) {
        this.m_lineInitials = string;
        this.m_visitor = new TreeVisitor();
    }

    public String getTreeString(IPTNode iPTNode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.printTreeString(iPTNode, byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public void printTreeString(IPTNode iPTNode, OutputStream outputStream) {
        if (null == iPTNode || null == outputStream) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        this.traverseTree(iPTNode, printWriter);
    }

    private void traverseTree(IPTNode iPTNode, PrintWriter printWriter) {
        Stack<StackElement> stack = new Stack<StackElement>();
        stack.push(new StackElement(0, null, iPTNode));
        while (!stack.empty()) {
            StackElement stackElement = (StackElement)stack.pop();
            this.writeElement(stackElement, printWriter);
            this.pushChildren(stack, stackElement);
        }
    }

    private void pushChildren(Stack<StackElement> stack, StackElement stackElement) {
        block5: {
            block4: {
                if (!(stackElement.node instanceof PTListNode)) break block4;
                PTListNode pTListNode = (PTListNode)stackElement.node;
                int n = stackElement.indent + 1;
                for (int i = pTListNode.numChildren() - 1; i >= 0; --i) {
                    try {
                        stack.push(new StackElement(n, null, pTListNode.getChild(i)));
                        continue;
                    }
                    catch (ErrorException errorException) {
                        throw new IndexOutOfBoundsException("node Corrupted: " + pTListNode.toString());
                    }
                }
                break block5;
            }
            if (!(stackElement.node instanceof PTNonterminalNode)) break block5;
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)stackElement.node;
            int n = stackElement.indent + 1;
            PTPositionalType[] pTPositionalTypeArray = pTNonterminalNode.getAllPositionalTypes().toArray(new PTPositionalType[0]);
            Arrays.sort(pTPositionalTypeArray, Collections.reverseOrder(new Comparator<PTPositionalType>(){

                @Override
                public int compare(PTPositionalType pTPositionalType, PTPositionalType pTPositionalType2) {
                    return pTPositionalType.name().compareTo(pTPositionalType2.name());
                }
            }));
            for (PTPositionalType pTPositionalType : pTPositionalTypeArray) {
                IPTNode iPTNode = pTNonterminalNode.getChild(pTPositionalType);
                stack.push(new StackElement(n, "POS_" + pTPositionalType.name(), iPTNode));
            }
        }
    }

    private void writeElement(StackElement stackElement, PrintWriter printWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_lineInitials);
        for (int i = 0; i < stackElement.indent; ++i) {
            stringBuilder.append(INDENT_STR);
        }
        try {
            stringBuilder.append(stackElement.node.acceptVisitor(this.m_visitor));
        }
        catch (ErrorException errorException) {
            throw new IllegalStateException(errorException);
        }
        if (null != stackElement.positionStr) {
            stringBuilder.append(" <-> ");
            stringBuilder.append(stackElement.positionStr);
        }
        printWriter.println(stringBuilder.toString());
    }

    private static class TreeVisitor
    implements IPTVisitor<String> {
        @Override
        public String visit(PTEmptyNode pTEmptyNode) {
            return "EMPTY_NODE";
        }

        @Override
        public String visit(PTIdentifierNode pTIdentifierNode) {
            return "IDENTIFIER : " + pTIdentifierNode.getIdentifier();
        }

        @Override
        public String visit(PTFlagNode pTFlagNode) {
            return "FLAG_NODE : " + pTFlagNode.getFlagType().name();
        }

        @Override
        public String visit(PTLiteralNode pTLiteralNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(pTLiteralNode.getLiteralType().name()).append("_LITERAL_NODE : ");
            switch (pTLiteralNode.getLiteralType()) {
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case CHARSTR: {
                    stringBuilder.append("'").append(pTLiteralNode.getStringValue()).append("'");
                    break;
                }
                default: {
                    stringBuilder.append(pTLiteralNode.getStringValue());
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public String visit(PTDynamicParameterNode pTDynamicParameterNode) {
            return "DYNAMIC_PARAMETER_NODE : " + pTDynamicParameterNode.getIndex();
        }

        @Override
        public String visit(PTNonterminalNode pTNonterminalNode) {
            return pTNonterminalNode.getNonterminalType().name() + "_NT_NODE";
        }

        @Override
        public String visit(PTDefaultParameterNode pTDefaultParameterNode) {
            return "DEFAULT_PARAMETER_NODE";
        }

        @Override
        public String visit(PTListNode pTListNode) {
            return pTListNode.getListType().name() + "_LIST_NODE";
        }
    }

    private static class StackElement {
        public int indent;
        public String positionStr;
        public IPTNode node;

        public StackElement(int n, String string, IPTNode iPTNode) {
            this.indent = n;
            this.positionStr = string;
            this.node = iPTNode;
        }
    }
}

