/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.utilities;

import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.IPTVisitor;
import com.databricks.client.sqlengine.parser.parsetree.PTDefaultParameterNode;
import com.databricks.client.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.databricks.client.sqlengine.parser.parsetree.PTEmptyNode;
import com.databricks.client.sqlengine.parser.parsetree.PTFlagNode;
import com.databricks.client.sqlengine.parser.parsetree.PTIdentifierNode;
import com.databricks.client.sqlengine.parser.parsetree.PTListNode;
import com.databricks.client.sqlengine.parser.parsetree.PTLiteralNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.parsetree.PTWalker;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Stack;

public class PTStringLogger {
    public static void writePTLogString(IPTNode iPTNode, OutputStream outputStream) {
        try {
            PTLogVisitor pTLogVisitor = new PTLogVisitor(outputStream);
            PTWalker.walkPreorderDepthFirst(iPTNode, pTLogVisitor);
            pTLogVisitor.flush();
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    private static class PTLogVisitor
    implements IPTVisitor<Void> {
        private static final String INDENT_STRING = "    ";
        private final Stack<Integer> m_indentStack = new Stack();
        private PrintWriter m_printWriter;
        private final Stack<String> m_childTypeStack = new Stack();

        public PTLogVisitor(OutputStream outputStream) {
            this.m_indentStack.push(0);
            this.m_printWriter = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        }

        public void flush() {
            this.m_printWriter.flush();
        }

        @Override
        public Void visit(PTEmptyNode pTEmptyNode) {
            this.writeString(pTEmptyNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTIdentifierNode pTIdentifierNode) {
            this.writeString(pTIdentifierNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTFlagNode pTFlagNode) {
            this.writeString(pTFlagNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTLiteralNode pTLiteralNode) {
            this.writeString(pTLiteralNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTDynamicParameterNode pTDynamicParameterNode) {
            this.writeString(pTDynamicParameterNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTDefaultParameterNode pTDefaultParameterNode) {
            this.writeString(pTDefaultParameterNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTNonterminalNode pTNonterminalNode) {
            this.writeString(pTNonterminalNode.toString(), pTNonterminalNode.numChildren());
            PTPositionalType[] pTPositionalTypeArray = pTNonterminalNode.getAllPositionalTypes().toArray(new PTPositionalType[0]);
            for (int i = pTPositionalTypeArray.length - 1; i >= 0; --i) {
                this.m_childTypeStack.push(pTPositionalTypeArray[i].name());
            }
            return null;
        }

        @Override
        public Void visit(PTListNode pTListNode) {
            this.writeString(pTListNode.toString(), pTListNode.numChildren());
            for (int i = pTListNode.numChildren() - 1; i >= 0; --i) {
                this.m_childTypeStack.push("" + i);
            }
            return null;
        }

        private void writeString(String string, int n) {
            int n2 = this.m_indentStack.pop();
            int n3 = n2 + 1;
            while (n > 0) {
                this.m_indentStack.push(n3);
                --n;
            }
            while (n2 > 0) {
                this.m_printWriter.print(INDENT_STRING);
                --n2;
            }
            if (!this.m_childTypeStack.isEmpty()) {
                this.m_printWriter.print(this.m_childTypeStack.pop());
                this.m_printWriter.print(": ");
            }
            this.m_printWriter.print(string);
            this.m_printWriter.print("\n");
        }
    }
}

