/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.utilities;

import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Stack;

public class AEStringLogger {
    public static void logAETree(IAENode iAENode, String string, String ... stringArray) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(Paths.get(string, new String[0]), StandardOpenOption.CREATE_NEW));){
            for (String string2 : stringArray) {
                printWriter.print(string2);
                printWriter.print("\n");
            }
            try {
                AEStringLogger.walkPreorderDepthFirst(iAENode, new AELogVisitor(printWriter));
            }
            catch (ErrorException errorException) {
                throw new RuntimeException(errorException);
            }
        }
    }

    public static String logAETreeToString(IAENode iAENode) throws ErrorException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        AEStringLogger.walkPreorderDepthFirst(iAENode, new AELogVisitor(printWriter));
        printWriter.flush();
        return stringWriter.toString();
    }

    private static void walkPreorderDepthFirst(IAENode iAENode, AELogVisitor aELogVisitor) throws ErrorException {
        if (null == iAENode) {
            return;
        }
        Stack<IAENode> stack = new Stack<IAENode>();
        stack.push(iAENode);
        ArrayList<IAENode> arrayList = new ArrayList<IAENode>();
        while (!stack.empty()) {
            IAENode iAENode2 = (IAENode)stack.pop();
            iAENode2.acceptVisitor(aELogVisitor);
            Iterator<? extends IAENode> iterator = iAENode2.getChildItr();
            arrayList.clear();
            while (iterator.hasNext()) {
                arrayList.add(Objects.requireNonNull(iterator.next()));
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                stack.push((IAENode)arrayList.get(i));
            }
        }
    }

    private static class AELogVisitor
    extends AEDefaultVisitor<Void> {
        private final Stack<Integer> m_indentStack = new Stack();
        private static final String INDENT_STRING = "    ";
        private PrintWriter m_printWriter;
        private final Stack<String> m_childTypeStack = new Stack();

        public AELogVisitor(PrintWriter printWriter) {
            this.m_indentStack.push(0);
            this.m_printWriter = printWriter;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            this.writeString(iAENode.getLogString(), iAENode.getNumChildren());
            return null;
        }

        private void writeString(String string, int n) {
            int n2 = this.m_indentStack.pop();
            int n3 = n2 + 1;
            while (n > 0) {
                this.m_indentStack.push(n3);
                --n;
            }
            while (n2 > 0) {
                this.m_printWriter.print(INDENT_STRING);
                --n2;
            }
            if (!this.m_childTypeStack.isEmpty()) {
                this.m_printWriter.print(this.m_childTypeStack.pop());
                this.m_printWriter.print(": ");
            }
            this.m_printWriter.print(string);
            this.m_printWriter.print("\n");
            for (int i = n - 1; i >= 0; --i) {
                this.m_childTypeStack.push("" + i);
            }
        }
    }
}

