/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.materializer;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.sqlengine.aeprocessor.aetree.AESortSpec;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExprScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEDummyTable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEExcept;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEProcedure;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESort;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETop;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.databricks.client.sqlengine.executor.etree.relation.ETDistinctMove;
import com.databricks.client.sqlengine.executor.etree.relation.ETDummyTable;
import com.databricks.client.sqlengine.executor.etree.relation.ETProcedure;
import com.databricks.client.sqlengine.executor.etree.relation.ETProject;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalCache;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.relation.ETSelect;
import com.databricks.client.sqlengine.executor.etree.relation.ETSort;
import com.databricks.client.sqlengine.executor.etree.relation.ETSubQuery;
import com.databricks.client.sqlengine.executor.etree.relation.ETTable;
import com.databricks.client.sqlengine.executor.etree.relation.ETTableConstructor;
import com.databricks.client.sqlengine.executor.etree.relation.ETTop;
import com.databricks.client.sqlengine.executor.etree.relation.ETUnionAll;
import com.databricks.client.sqlengine.executor.etree.temptable.SortedTemporaryTable;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryTable;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.databricks.client.sqlengine.executor.etree.value.ETParameter;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExprList;
import com.databricks.client.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.databricks.client.sqlengine.executor.materializer.ETAggregateMaterializer;
import com.databricks.client.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.databricks.client.sqlengine.executor.materializer.ETJoinMaterializer;
import com.databricks.client.sqlengine.executor.materializer.ETTableMaterializer;
import com.databricks.client.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.databricks.client.sqlengine.executor.materializer.MaterializerBase;
import com.databricks.client.sqlengine.executor.materializer.MaterializerContext;
import com.databricks.client.sqlengine.executor.queryplan.IQueryPlan;
import com.databricks.client.sqlengine.utilities.ExternalAlgorithmUtil;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ETRelationalExprMaterializer
extends MaterializerBase<ETRelationalExpr> {
    private boolean m_errorOnTruncate = false;

    public ETRelationalExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public ETRelationalExpr visit(AEAggregate aEAggregate) throws ErrorException {
        return new ETAggregateMaterializer(this, this.getQueryPlan(), this.getContext()).visit(aEAggregate);
    }

    @Override
    public ETRelationalExpr visit(AECommonTableExprScope aECommonTableExprScope) throws ErrorException {
        return aECommonTableExprScope.getRightOperand().acceptVisitor(this);
    }

    @Override
    public ETRelationalExpr visit(AECrossJoin aECrossJoin) throws ErrorException {
        return new ETJoinMaterializer(this.getQueryPlan(), this.getContext(), aECrossJoin, this).materialize();
    }

    @Override
    public ETRelationalExpr visit(AEDistinct aEDistinct) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aEDistinct);
        List<IColumn> list = ETRelationalExprMaterializer.calculateMetadata(aEDistinct.getOperand());
        ETRelationalExpr eTRelationalExpr = aEDistinct.getOperand().acceptVisitor(this);
        return this.doMaterializeDistinct(eTRelationalExpr, blArray, list);
    }

    @Override
    public ETRelationalExpr visit(AEJoin aEJoin) throws ErrorException {
        return new ETJoinMaterializer(this.getQueryPlan(), this.getContext(), aEJoin, this).materialize();
    }

    @Override
    public ETRelationalExpr visit(AEProject aEProject) throws ErrorException {
        Object object;
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aEProject);
        ETRelationalExpr eTRelationalExpr = aEProject.getOperand().acceptVisitor(this);
        ETValueExprList eTValueExprList = new ETValueExprList();
        Iterator iterator = aEProject.getProjectionList().getChildItr();
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        while (iterator.hasNext()) {
            object = (AEValueExpr)iterator.next();
            arrayList.add(((AEValueExpr)object).getColumn());
            ETValueExprMaterializer eTValueExprMaterializer = this.createValueExprMaterializer();
            ETValueExpr eTValueExpr = object.acceptVisitor(eTValueExprMaterializer);
            eTValueExprList.addNode(eTValueExpr);
        }
        object = new ETProject(eTRelationalExpr, eTValueExprList, arrayList, blArray);
        this.getContext().setMaterializedRelation(aEProject, (ETRelationalExpr)object);
        return object;
    }

    @Override
    public ETRelationalExpr visit(AESelect aESelect) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aESelect);
        ETRelationalExpr eTRelationalExpr = aESelect.getOperand().acceptVisitor(this);
        ETBooleanExpr eTBooleanExpr = aESelect.getCondition().acceptVisitor(this.createBooleanExprMaterializer());
        ETSelect eTSelect = new ETSelect(eTRelationalExpr, eTBooleanExpr, blArray);
        this.getContext().setMaterializedRelation(aESelect, eTSelect);
        return eTSelect;
    }

    @Override
    public ETRelationalExpr visit(AESort aESort) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aESort.getOperand());
        ETRelationalExpr eTRelationalExpr = aESort.getOperand().acceptVisitor(this);
        int n = eTRelationalExpr.getColumnCount();
        List<IColumn> list = new ArrayList<IColumn>(n);
        for (int i = 0; i < n; ++i) {
            list.add(eTRelationalExpr.getColumn(i));
        }
        MaterializerContext materializerContext = this.getContext();
        TemporaryTableBuilder temporaryTableBuilder = new TemporaryTableBuilder(list, materializerContext.getDataEngineContext().getDataEngine(), materializerContext.getExternalAlgorithmProperties(), materializerContext.getCancelState(), blArray);
        SortedTemporaryTable sortedTemporaryTable = temporaryTableBuilder.sortSpec(aESort.getSortSpecs()).buildSorted();
        if (aESort.getColumnCount() < n) {
            list = list.subList(0, aESort.getColumnCount());
        }
        list = new ArrayList<IColumn>(list);
        return new ETSort(eTRelationalExpr, list, sortedTemporaryTable, blArray);
    }

    @Override
    public ETRelationalExpr visit(AESubQuery aESubQuery) throws ErrorException {
        ETRelationalExpr eTRelationalExpr = aESubQuery.getOperand().acceptVisitor(this);
        boolean bl = aESubQuery.isCorrelated();
        boolean bl2 = aESubQuery.isInFromClause();
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aESubQuery.getOperand());
        if (!bl && !bl2) {
            ArrayList<IColumn> arrayList = aESubQuery.createResultSetColumns();
            ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties = this.getContext().getExternalAlgorithmProperties();
            TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties = new TemporaryTableBuilder.TemporaryTableProperties(externalAlgorithmProperties.getStorageDir(), externalAlgorithmProperties.getCellMemoryLimit(), externalAlgorithmProperties.getBlockSize(), ExternalAlgorithmUtil.calculateRowSize(arrayList, blArray, externalAlgorithmProperties.getCellMemoryLimit()), externalAlgorithmProperties.getMaxNumOpenFiles(), externalAlgorithmProperties.getLogger(), "SubQuery");
            ETRelationalCache eTRelationalCache = new ETRelationalCache(eTRelationalExpr, new TemporaryTable(arrayList, temporaryTableProperties, blArray));
            this.getContext().setMaterializedRelation(aESubQuery, eTRelationalCache);
            return eTRelationalCache;
        }
        ETSubQuery eTSubQuery = new ETSubQuery(eTRelationalExpr, bl, blArray);
        this.getContext().setMaterializedRelation(aESubQuery, eTSubQuery);
        return eTSubQuery;
    }

    @Override
    public ETTable visit(AETable aETable) throws ErrorException {
        ETTable eTTable = aETable.acceptVisitor(new ETTableMaterializer(this.getQueryPlan(), this.getContext()));
        return eTTable;
    }

    @Override
    public ETDummyTable visit(AEDummyTable aEDummyTable) throws ErrorException {
        return new ETDummyTable();
    }

    @Override
    public ETRelationalExpr visit(AETableConstructor aETableConstructor) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aETableConstructor);
        ETValueExprMaterializer eTValueExprMaterializer = this.createValueExprMaterializer();
        List<IColumn> list = aETableConstructor.getResultSetColumns();
        ETTableConstructor eTTableConstructor = null;
        for (int i = aETableConstructor.getNumChildren() - 1; i >= 0; --i) {
            ETValueExprList eTValueExprList = new ETValueExprList();
            int n = 0;
            for (AEValueExpr aEValueExpr : aETableConstructor.getRow(i)) {
                eTValueExprList.addNode(ConvMaterializeUtil.addConversionNodeWhenNeeded(aEValueExpr.acceptVisitor(eTValueExprMaterializer), aEValueExpr.getColumn(), list.get(n++), this.isErrorOnTruncate(), this.getContext()));
            }
            ETTableConstructor eTTableConstructor2 = new ETTableConstructor(eTValueExprList, aETableConstructor.getResultSetColumns(), blArray);
            eTTableConstructor = null == eTTableConstructor ? eTTableConstructor2 : new ETUnionAll(eTTableConstructor2, eTTableConstructor, blArray);
        }
        this.getContext().setMaterializedRelation(aETableConstructor, eTTableConstructor);
        return eTTableConstructor;
    }

    @Override
    public ETRelationalExpr visit(AETop aETop) throws ErrorException {
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aETop);
        ETRelationalExpr eTRelationalExpr = aETop.getOperand().acceptVisitor(this);
        ETValueExprMaterializer eTValueExprMaterializer = this.createValueExprMaterializer();
        ETValueExpr eTValueExpr = aETop.getSelectLimitExpr().acceptVisitor(eTValueExprMaterializer);
        AEValueExpr aEValueExpr = aETop.getSkipExpr();
        ETValueExpr eTValueExpr2 = null;
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aETop.getSelectLimitExpr().getColumn(), new ColumnMetadata(TypeMetadata.createTypeMetadata(-5, false)), this.getContext());
        if (null != aEValueExpr) {
            eTValueExpr2 = aETop.getSkipExpr().acceptVisitor(eTValueExprMaterializer);
            eTValueExpr2 = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr2, aETop.getSkipExpr().getColumn(), new ColumnMetadata(TypeMetadata.createTypeMetadata(-5, false)), this.getContext());
        }
        return new ETTop(eTRelationalExpr, blArray, eTValueExpr, eTValueExpr2, aETop.isPercent());
    }

    @Override
    public ETRelationalExpr visit(AEUnion aEUnion) throws ErrorException {
        ETRelationalExpr eTRelationalExpr = aEUnion.getLeftOperand().acceptVisitor(this);
        ETRelationalExpr eTRelationalExpr2 = aEUnion.getRightOperand().acceptVisitor(this);
        List<IColumn> list = ETRelationalExprMaterializer.calculateMetadata(aEUnion);
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aEUnion);
        boolean bl = false;
        MaterializerContext materializerContext = this.getContext();
        ConvMaterializeUtil.makeNewRelationConvertNode(list, eTRelationalExpr, blArray, bl, materializerContext);
        ConvMaterializeUtil.makeNewRelationConvertNode(list, eTRelationalExpr2, blArray, bl, materializerContext);
        ETUnionAll eTUnionAll = new ETUnionAll(eTRelationalExpr, eTRelationalExpr2, blArray);
        if (aEUnion.isAllOptPresent()) {
            return eTUnionAll;
        }
        return this.doMaterializeDistinct(eTUnionAll, blArray, list);
    }

    @Override
    public ETRelationalExpr visit(AEProcedure aEProcedure) throws ErrorException {
        List<ProcedureParameterMetadata> list = aEProcedure.getAllExpectedProcParamMeta();
        boolean[] blArray = ETRelationalExprMaterializer.calculateDataNeeded(aEProcedure);
        ETValueExprList eTValueExprList = new ETValueExprList();
        Iterator iterator = aEProcedure.getArguments().getChildItr();
        ETValueExprMaterializer eTValueExprMaterializer = this.createValueExprMaterializer();
        int n = 0;
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
            ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(eTValueExprMaterializer);
            if (eTValueExpr instanceof ETParameter) {
                ((ETParameter)eTValueExpr).updateParamType(list.get(n).getParameterType());
            }
            IColumn iColumn = aEValueExpr.getColumn();
            ColumnMetadata columnMetadata = list.get(n).getEquivalentColumnMeta();
            eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, iColumn, columnMetadata, this.getContext());
            eTValueExprList.addNode(eTValueExpr);
            ++n;
        }
        return new ETProcedure(aEProcedure.getProcedure(), list, eTValueExprList, blArray, aEProcedure.callHasReturnValue());
    }

    @Override
    public ETRelationalExpr visit(AEExcept aEExcept) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("EXCEPT");
    }

    public boolean isErrorOnTruncate() {
        return this.m_errorOnTruncate;
    }

    public void setErrorOnTruncate(boolean bl) {
        this.m_errorOnTruncate = bl;
    }

    protected ETValueExprMaterializer createValueExprMaterializer() {
        return new ETValueExprMaterializer(this.getQueryPlan(), this.getContext());
    }

    protected ETBoolExprMaterializer createBooleanExprMaterializer() {
        return new ETBoolExprMaterializer(this.getQueryPlan(), this.getContext());
    }

    private static boolean[] calculateDataNeeded(AERelationalExpr aERelationalExpr) {
        boolean[] blArray = new boolean[aERelationalExpr.getColumnCount()];
        for (int i = 0; i < blArray.length; ++i) {
            if (!aERelationalExpr.getDataNeeded(i)) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private static List<IColumn> calculateMetadata(AERelationalExpr aERelationalExpr) {
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>(aERelationalExpr.getColumnCount());
        for (int i = 0; i < aERelationalExpr.getColumnCount(); ++i) {
            arrayList.add(aERelationalExpr.getColumn(i));
        }
        return arrayList;
    }

    private ETRelationalExpr doMaterializeDistinct(ETRelationalExpr eTRelationalExpr, boolean[] blArray, List<IColumn> list) throws ErrorException {
        int n = eTRelationalExpr.getColumnCount();
        ArrayList<AESortSpec> arrayList = new ArrayList<AESortSpec>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new AESortSpec(i, true));
        }
        MaterializerContext materializerContext = this.getContext();
        TemporaryTableBuilder temporaryTableBuilder = new TemporaryTableBuilder(list, materializerContext.getDataEngineContext().getDataEngine(), materializerContext.getExternalAlgorithmProperties(), materializerContext.getCancelState(), blArray);
        SortedTemporaryTable sortedTemporaryTable = temporaryTableBuilder.sortSpec(arrayList).buildSorted();
        ETSort eTSort = new ETSort(eTRelationalExpr, list, sortedTemporaryTable, blArray);
        return new ETDistinctMove(eTSort, list, sortedTemporaryTable.getRowComparator(), this.getContext().getExternalAlgorithmProperties(), blArray);
    }
}

