/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.sqlengine.aeprocessor.AEUtils;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.conversions.ConversionUtil;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.conv.ApproxNumConverter;
import com.databricks.client.support.conv.ConversionResult;
import com.databricks.client.support.conv.ExactNumConverter;
import com.databricks.client.support.conv.IntegralConverter;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

public final class ETRoundFn
extends ETScalarFn {
    private final int m_numericType;

    public ETRoundFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        this.m_numericType = iColumn.getTypeMetadata().getType();
        assert (TypeUtilities.isNumberType(this.m_numericType));
        assert (2 == this.getNumChildren());
        assert (AEUtils.isTypeNumeric(list2.get(0).getTypeMetadata().getType()));
        assert (4 == list2.get(1).getTypeMetadata().getType());
    }

    @Override
    public String getLogString() {
        return "ETRoundFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l = iSqlDataWrapper2.getInteger();
        if (l > 32767L || l < -32768L) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("ROUND", 2);
        }
        int n = (int)l;
        switch (this.m_numericType) {
            case 2: 
            case 3: {
                TypeMetadata typeMetadata = this.getResultMetadata().getTypeMetadata();
                BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
                int n2 = bigDecimal.scale();
                RoundingMode roundingMode = 0 <= bigDecimal.compareTo(BigDecimal.ZERO) ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN;
                bigDecimal = bigDecimal.setScale(n, roundingMode);
                bigDecimal = bigDecimal.setScale(n2);
                ConversionResult conversionResult = new ConversionResult();
                BigDecimal bigDecimal2 = ExactNumConverter.setPrecScale(bigDecimal, typeMetadata.getPrecision(), typeMetadata.getScale(), conversionResult);
                ETRoundFn.checkError(conversionResult);
                eTDataRequest.getData().setExactNumber(bigDecimal2);
                break;
            }
            case -5: {
                BigInteger bigInteger = iSqlDataWrapper.getBigInt();
                if (0 > n) {
                    if (-n <= 21) {
                        BigInteger bigInteger2 = BigInteger.valueOf(10L).pow(-n);
                        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
                        BigInteger bigInteger3 = bigIntegerArray[0];
                        BigInteger bigInteger4 = bigIntegerArray[1];
                        boolean bl = false;
                        if (0 <= bigInteger4.compareTo(BigInteger.ZERO)) {
                            if (0 <= bigInteger4.shiftLeft(1).compareTo(bigInteger2)) {
                                bigInteger3 = bigInteger3.add(BigInteger.ONE);
                                bl = true;
                            }
                        } else if (0 < bigInteger4.negate().shiftLeft(1).compareTo(bigInteger2)) {
                            bigInteger3 = bigInteger3.subtract(BigInteger.ONE);
                            bl = true;
                        }
                        bigInteger = bigInteger3.multiply(bigInteger2);
                        if (bl) {
                            ConversionResult conversionResult = new ConversionResult();
                            bigInteger = IntegralConverter.toBigInt(bigInteger, this.getResultMetadata().getTypeMetadata().isSigned(), conversionResult);
                            ETRoundFn.checkError(conversionResult);
                        }
                    } else {
                        bigInteger = BigInteger.ZERO;
                    }
                }
                eTDataRequest.getData().setBigInt(bigInteger);
                break;
            }
            case 4: {
                if (0 > n) {
                    double d = iSqlDataWrapper.getDouble() * Math.pow(10.0, n);
                    d = (double)Math.round(d) * Math.pow(10.0, -n);
                    eTDataRequest.getData().setInteger((long)d);
                    break;
                }
                eTDataRequest.getData().setInteger(iSqlDataWrapper.getInteger());
                break;
            }
            case 5: {
                if (0 > n) {
                    double d = iSqlDataWrapper.getDouble() * Math.pow(10.0, n);
                    d = (double)Math.round(d) * Math.pow(10.0, -n);
                    eTDataRequest.getData().setSmallInt((int)d);
                    break;
                }
                eTDataRequest.getData().setSmallInt(iSqlDataWrapper.getSmallInt());
                break;
            }
            case -6: {
                if (0 > n) {
                    double d = iSqlDataWrapper.getDouble() * Math.pow(10.0, n);
                    d = (double)Math.round(d) * Math.pow(10.0, -n);
                    eTDataRequest.getData().setTinyInt((short)d);
                    break;
                }
                eTDataRequest.getData().setTinyInt(iSqlDataWrapper.getTinyInt());
                break;
            }
            case 7: {
                double d = iSqlDataWrapper.getDouble();
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    eTDataRequest.getData().setReal((float)d);
                    return false;
                }
                RoundingMode roundingMode = d >= 0.0 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN;
                BigDecimal bigDecimal = new BigDecimal(d).setScale(n, roundingMode);
                ConversionResult conversionResult = new ConversionResult();
                float f = ApproxNumConverter.toFloat(bigDecimal.doubleValue(), conversionResult);
                ETRoundFn.checkError(conversionResult);
                eTDataRequest.getData().setReal(f);
                break;
            }
            default: {
                assert (8 == this.m_numericType || 6 == this.m_numericType);
                double d = iSqlDataWrapper.getDouble();
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    eTDataRequest.getData().setDouble(d);
                    return false;
                }
                RoundingMode roundingMode = d >= 0.0 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN;
                BigDecimal bigDecimal = new BigDecimal(d).setScale(n, roundingMode);
                eTDataRequest.getData().setDouble(bigDecimal.doubleValue());
                break;
            }
        }
        return false;
    }

    private static void checkError(ConversionResult conversionResult) throws ErrorException {
        ConversionUtil.checkForErrorOnly(conversionResult, false, -1, -1);
    }
}

