/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor;

import com.databricks.client.sqlengine.aeprocessor.AEQTableName;
import com.databricks.client.sqlengine.aeprocessor.AEUtils;

public final class AEQColumnName {
    private AEQTableName m_qTable;
    private String m_colName;

    public AEQColumnName(AEQTableName aEQTableName, String string) {
        if (null == string || null == aEQTableName) {
            throw new IllegalArgumentException("null parameters are not allowed.");
        }
        this.m_qTable = aEQTableName;
        this.m_colName = string;
    }

    public String getColName() {
        return this.m_colName;
    }

    public String getCatalogName() {
        return this.m_qTable.getCatalogName();
    }

    public String getSchemaName() {
        return this.m_qTable.getSchemaName();
    }

    public String getTableName() {
        return this.m_qTable.getTableName();
    }

    public AEQTableName getQTable() {
        return this.m_qTable;
    }

    public boolean hasQualifier() {
        return this.m_qTable.hasTableName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (0 < this.getCatalogName().length()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.getCatalogName())).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.getSchemaName())).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.getTableName())).append(".");
        } else if (0 < this.getSchemaName().length()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.getSchemaName())).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.getTableName())).append(".");
        } else if (0 < this.getTableName().length()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.getTableName())).append(".");
        }
        stringBuilder.append(AEUtils.sqlQuoted(this.getColName()));
        return stringBuilder.toString();
    }
}

